/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.result;

import com.helger.bdve.api.result.ValidationResult;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValidationResultList
extends CommonsArrayList<ValidationResult> {
    public boolean containsNoFailure() {
        return this.containsOnly(validationResult -> validationResult.getErrorList().containsNoFailure());
    }

    public boolean containsNoError() {
        return this.containsOnly(validationResult -> validationResult.getErrorList().containsNoError());
    }

    public boolean containsAtLeastOneFailure() {
        return this.containsAny(validationResult -> validationResult.getErrorList().containsAtLeastOneFailure());
    }

    public boolean containsAtLeastOneError() {
        return this.containsAny(validationResult -> validationResult.getErrorList().containsAtLeastOneError());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getAllFailures() {
        ErrorList errorList = new ErrorList();
        for (ValidationResult validationResult : this) {
            errorList.addAll(validationResult.getErrorList().getAllFailures());
        }
        return errorList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getAllErrors() {
        ErrorList errorList = new ErrorList();
        for (ValidationResult validationResult : this) {
            errorList.addAll(validationResult.getErrorList().getAllErrors());
        }
        return errorList;
    }

    @Nonnegative
    public int getAllCount(@Nullable Predicate<? super IError> predicate) {
        int n = 0;
        for (ValidationResult validationResult : this) {
            n += validationResult.getErrorList().getCount(predicate);
        }
        return n;
    }

    public void forEachFlattened(@Nonnull Consumer<? super IError> consumer) {
        for (ValidationResult validationResult : this) {
            validationResult.getErrorList().forEach(consumer);
        }
    }
}

