/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.engine.xsd;

import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.bdve.api.execute.AbstractValidationExecutor;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.engine.source.IValidationSourceXML;
import com.helger.bdve.engine.source.ValidationSourceXML;
import com.helger.bdve.engine.xsd.XSDPartialContext;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.location.SimpleLocation;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class ValidationExecutorXSDPartial
extends AbstractValidationExecutor<IValidationSourceXML, ValidationExecutorXSDPartial> {
    private final XSDPartialContext m_aContext;

    public ValidationExecutorXSDPartial(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull XSDPartialContext xSDPartialContext) {
        super(iValidationArtefact);
        ValueEnforcer.isTrue(iValidationArtefact.getValidationArtefactType().isXSD(), "Artifact is not an XSD");
        this.m_aContext = ValueEnforcer.notNull(xSDPartialContext, "Context");
    }

    @Nonnull
    public final XSDPartialContext getContext() {
        return this.m_aContext;
    }

    @Override
    @Nonnull
    public ValidationResult applyValidation(@Nonnull IValidationSourceXML iValidationSourceXML, @Nullable Locale locale) {
        NodeList nodeList;
        ValueEnforcer.notNull(iValidationSourceXML, "Source");
        IValidationArtefact iValidationArtefact = this.getValidationArtefact();
        try {
            nodeList = (NodeList)this.m_aContext.getXPathExpression().evaluate(iValidationSourceXML.getNode(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalStateException(xPathExpressionException);
        }
        ErrorList errorList = new ErrorList();
        int n = nodeList.getLength();
        if (this.m_aContext.hasMinNodeCount() && n < this.m_aContext.getMinNodeCount()) {
            errorList.add(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderFatalError().setErrorLocation(new SimpleLocation(iValidationArtefact.getRuleResource().getPath()))).setErrorText("The minimum number of result nodes (" + this.m_aContext.getMinNodeCount() + ") is not met")).build());
        }
        if (this.m_aContext.hasMaxNodeCount() && n > this.m_aContext.getMaxNodeCount()) {
            errorList.add(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderFatalError().setErrorLocation(new SimpleLocation(iValidationArtefact.getRuleResource().getPath()))).setErrorText("The maximum number of result nodes (" + this.m_aContext.getMaxNodeCount() + ") is not met")).build());
        }
        if (n == 0) {
            return new ValidationResult(iValidationArtefact, errorList);
        }
        Schema schema = XMLSchemaCache.getInstance().getSchema(iValidationArtefact.getRuleResource());
        assert (schema != null);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ValidationSourceXML validationSourceXML = new ValidationSourceXML(iValidationSourceXML.getSystemID(), nodeList.item(i), true);
            try {
                XMLSchemaValidationHelper.validate(schema, validationSourceXML.getAsTransformSource(), errorList, locale);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getCause() instanceof SAXParseException) {
                    errorList.add(AbstractSAXErrorHandler.getSaxParseError(EErrorLevel.FATAL_ERROR, (SAXParseException)illegalArgumentException.getCause()));
                    continue;
                }
                errorList.add(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderFatalError().setErrorLocation(new SimpleLocation(iValidationArtefact.getRuleResource().getPath()))).setErrorFieldName("Context[" + i + "]")).setErrorText("The document to be validated is not an XML document")).setLinkedException(illegalArgumentException)).build());
            }
        }
        return new ValidationResult(iValidationArtefact, errorList.getAllFailures());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

