/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.engine.xsd;

import com.helger.commons.ValueEnforcer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.xpath.XPathExpression;

@NotThreadSafe
public class XSDPartialContext {
    private final XPathExpression m_aXE;
    private final Integer m_aMinNodeCount;
    private final Integer m_aMaxNodeCount;

    public XSDPartialContext(@Nonnull XPathExpression xPathExpression, @Nullable Integer n, @Nullable Integer n2) {
        ValueEnforcer.notNull(xPathExpression, "XPathExpression");
        this.m_aXE = xPathExpression;
        this.m_aMinNodeCount = n;
        this.m_aMaxNodeCount = n2;
    }

    @Nonnull
    public XPathExpression getXPathExpression() {
        return this.m_aXE;
    }

    public boolean hasMinNodeCount() {
        return this.m_aMinNodeCount != null;
    }

    public int getMinNodeCount() {
        return this.m_aMinNodeCount;
    }

    public boolean hasMaxNodeCount() {
        return this.m_aMaxNodeCount != null;
    }

    public int getMaxNodeCount() {
        return this.m_aMaxNodeCount;
    }
}

