/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.json;

import com.helger.bdve.api.EValidationType;
import com.helger.bdve.api.artefact.ValidationArtefact;
import com.helger.bdve.api.executorset.IValidationExecutorSet;
import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.executorset.ValidationExecutorSetRegistry;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.api.result.ValidationResultList;
import com.helger.bdve.api.source.IValidationSource;
import com.helger.bdve.json.BDVERestoredException;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.text.ConstantHasErrorText;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.mutable.MutableInt;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.schematron.svrl.SVRLResourceError;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class BDVEJsonHelper {
    public static final String JSON_ERRORLEVEL_SUCCESS = "SUCCESS";
    public static final String JSON_ERRORLEVEL_WARN = "WARN";
    public static final String JSON_ERRORLEVEL_ERROR = "ERROR";
    public static final String JSON_TRISTATE_TRUE = "TRUE";
    public static final String JSON_TRISTATE_FALSE = "FALSE";
    public static final String JSON_TRISTATE_UNDEFINED = "UNDEFINED";
    public static final String JSON_CLASS = "class";
    public static final String JSON_MESSAGE = "message";
    public static final String JSON_STACK_TRACE = "stackTrace";
    public static final String JSON_RESOURCE_ID = "resource";
    public static final String JSON_LINE_NUM = "line";
    public static final String JSON_COLUMN_NUM = "col";
    public static final String JSON_ERROR_LEVEL = "errorLevel";
    public static final String JSON_ERROR_ID = "errorID";
    public static final String JSON_ERROR_FIELD_NAME = "errorFieldName";
    public static final String JSON_ERROR_LOCATION_OBJ = "errorLocationObj";
    public static final String JSON_ERROR_LOCATION_STR = "errorLocation";
    public static final String JSON_ERROR_TEXT = "errorText";
    public static final String JSON_EXCEPTION = "exception";
    public static final String JSON_TEST = "test";
    public static final String JSON_VESID = "vesid";
    public static final String JSON_NAME = "name";
    public static final String JSON_DEPRECATED = "deprecated";
    public static final String JSON_SUCCESS = "success";
    public static final String JSON_ARTIFACT_TYPE = "artifactType";
    public static final String JSON_ARTIFACT_PATH_TYPE = "artifactPathType";
    public static final String JSON_ARTIFACT_PATH = "artifactPath";
    public static final String JSON_ITEMS = "items";
    public static final String JSON_INTERRUPTED = "interrupted";
    public static final String JSON_MOST_SEVERE_ERROR_LEVEL = "mostSevereErrorLevel";
    public static final String JSON_RESULTS = "results";
    public static final String JSON_DURATION_MS = "durationMS";
    public static final String JSON_VES = "ves";
    public static final String ARTFACT_TYPE_INPUT_PARAMETER = "input-parameter";
    public static final String ARTIFACT_PATH_NONE = "none";
    private static final Logger LOGGER = LoggerFactory.getLogger(BDVEJsonHelper.class);

    private BDVEJsonHelper() {
    }

    private static boolean _isConsideredError(@Nonnull IErrorLevel iErrorLevel) {
        return iErrorLevel.isGE(EErrorLevel.ERROR);
    }

    private static boolean _isConsideredWarning(@Nonnull IErrorLevel iErrorLevel) {
        return iErrorLevel.isGE(EErrorLevel.WARN);
    }

    @Nonnull
    @Nonempty
    public static String getJsonErrorLevel(@Nonnull IErrorLevel iErrorLevel) {
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        if (BDVEJsonHelper._isConsideredError(iErrorLevel)) {
            return JSON_ERRORLEVEL_ERROR;
        }
        if (BDVEJsonHelper._isConsideredWarning(iErrorLevel)) {
            return JSON_ERRORLEVEL_WARN;
        }
        return JSON_ERRORLEVEL_SUCCESS;
    }

    @Nullable
    public static IErrorLevel getAsErrorLevel(@Nullable String string) {
        if (JSON_ERRORLEVEL_ERROR.equals(string)) {
            return EErrorLevel.ERROR;
        }
        if (JSON_ERRORLEVEL_WARN.equals(string)) {
            return EErrorLevel.WARN;
        }
        if (JSON_ERRORLEVEL_SUCCESS.equals(string)) {
            return EErrorLevel.SUCCESS;
        }
        return null;
    }

    @Nonnull
    @Nonempty
    public static String getJsonTriState(boolean bl) {
        return bl ? JSON_TRISTATE_TRUE : JSON_TRISTATE_FALSE;
    }

    @Nonnull
    public static String getJsonTriState(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "TriState");
        if (eTriState.isUndefined()) {
            return JSON_TRISTATE_UNDEFINED;
        }
        return BDVEJsonHelper.getJsonTriState(eTriState.isTrue());
    }

    @Nullable
    public static ETriState getAsTriState(@Nullable String string) {
        if (JSON_TRISTATE_TRUE.equals(string)) {
            return ETriState.TRUE;
        }
        if (JSON_TRISTATE_FALSE.equals(string)) {
            return ETriState.FALSE;
        }
        if (JSON_TRISTATE_UNDEFINED.equals(string)) {
            return ETriState.UNDEFINED;
        }
        return null;
    }

    @Nullable
    public static IJsonObject getJsonStackTrace(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof BDVERestoredException) {
            return ((BDVERestoredException)throwable).getAsJson();
        }
        return new JsonObject().add(JSON_CLASS, throwable.getClass().getName()).addIfNotNull(JSON_MESSAGE, throwable.getMessage()).add(JSON_STACK_TRACE, StackTraceHelper.getStackAsString(throwable));
    }

    @Nullable
    public static IJsonObject getJsonErrorLocation(@Nullable ILocation iLocation) {
        if (iLocation == null || !iLocation.isAnyInformationPresent()) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        if (iLocation.hasResourceID()) {
            jsonObject.add(JSON_RESOURCE_ID, iLocation.getResourceID());
        }
        if (iLocation.hasLineNumber()) {
            jsonObject.add(JSON_LINE_NUM, iLocation.getLineNumber());
        }
        if (iLocation.hasColumnNumber()) {
            jsonObject.add(JSON_COLUMN_NUM, iLocation.getColumnNumber());
        }
        return jsonObject;
    }

    @Nullable
    public static ILocation getAsErrorLocation(@Nullable IJsonObject iJsonObject) {
        if (iJsonObject == null) {
            return null;
        }
        String string = iJsonObject.getAsString(JSON_RESOURCE_ID);
        int n = iJsonObject.getAsInt(JSON_LINE_NUM, -1);
        int n2 = iJsonObject.getAsInt(JSON_COLUMN_NUM, -1);
        if (StringHelper.hasNoText(string) && n < 0 && n2 < 0) {
            return null;
        }
        return new SimpleLocation(string, n, n2);
    }

    @Nonnull
    public static IJsonObject getJsonError(@Nonnull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2, @Nullable ILocation iLocation, @Nullable String string3, @Nonnull String string4, @Nullable Throwable throwable) {
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        ValueEnforcer.notNull(string4, "ErrorText");
        return new JsonObject().add(JSON_ERROR_LEVEL, BDVEJsonHelper.getJsonErrorLevel(iErrorLevel)).addIfNotNull(JSON_ERROR_ID, string).addIfNotNull(JSON_ERROR_FIELD_NAME, string2).addIfNotNull(JSON_ERROR_LOCATION_OBJ, BDVEJsonHelper.getJsonErrorLocation(iLocation)).addIfNotNull(JSON_TEST, string3).add(JSON_ERROR_TEXT, string4).addIfNotNull(JSON_EXCEPTION, BDVEJsonHelper.getJsonStackTrace(throwable));
    }

    @Nonnull
    public static IJsonObject getJsonError(@Nonnull IError iError, @Nonnull Locale locale) {
        ValueEnforcer.notNull(iError, "Error");
        ValueEnforcer.notNull(locale, "DisplayLocale");
        return BDVEJsonHelper.getJsonError(iError.getErrorLevel(), iError.getErrorID(), iError.getErrorFieldName(), iError.hasErrorLocation() ? iError.getErrorLocation() : null, iError instanceof SVRLResourceError ? ((SVRLResourceError)iError).getTest() : null, iError.getErrorText(locale), iError.getLinkedException());
    }

    @Nonnull
    public static IError getAsIError(@Nonnull IJsonObject iJsonObject) {
        Object object;
        IErrorLevel iErrorLevel = BDVEJsonHelper.getAsErrorLevel(iJsonObject.getAsString(JSON_ERROR_LEVEL));
        String string = iJsonObject.getAsString(JSON_ERROR_ID);
        String string2 = iJsonObject.getAsString(JSON_ERROR_FIELD_NAME);
        ILocation iLocation = BDVEJsonHelper.getAsErrorLocation(iJsonObject.getAsObject(JSON_ERROR_LOCATION_OBJ));
        if (iLocation == null && (object = iJsonObject.getAsValue(JSON_ERROR_LOCATION_STR)) != null) {
            iLocation = new SimpleLocation(object.getAsString());
        }
        object = iJsonObject.getAsString(JSON_ERROR_TEXT);
        String string3 = iJsonObject.getAsString(JSON_TEST);
        BDVERestoredException bDVERestoredException = BDVERestoredException.createFromJson(iJsonObject.getAsObject(JSON_EXCEPTION));
        if (string3 != null) {
            return new SVRLResourceError(iErrorLevel, string, string2, iLocation, new ConstantHasErrorText((String)object), bDVERestoredException, string3);
        }
        return new SingleError(iErrorLevel, string, string2, iLocation, new ConstantHasErrorText((String)object), bDVERestoredException);
    }

    @Nonnull
    public static IJsonObject getJsonVES(@Nonnull IValidationExecutorSet<?> iValidationExecutorSet) {
        ValueEnforcer.notNull(iValidationExecutorSet, "VES");
        return new JsonObject().add(JSON_VESID, ((VESID)iValidationExecutorSet.getID()).getAsSingleID()).add(JSON_NAME, iValidationExecutorSet.getDisplayName()).add(JSON_DEPRECATED, iValidationExecutorSet.isDeprecated());
    }

    public static void applyGlobalError(@Nonnull IJsonObject iJsonObject, @Nonnull String string, @Nonnegative long l) {
        ValueEnforcer.notNull(iJsonObject, "Response");
        ValueEnforcer.notNull(string, "ErrorMsg");
        ValueEnforcer.isGE0(l, "DurationMilliseconds");
        JsonArray jsonArray = new JsonArray();
        IJsonObject iJsonObject2 = BDVEJsonHelper.getJsonError(((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorText(string)).build(), CGlobal.DEFAULT_LOCALE);
        jsonArray.add(new JsonObject().add(JSON_SUCCESS, BDVEJsonHelper.getJsonTriState(false)).add(JSON_ARTIFACT_TYPE, ARTFACT_TYPE_INPUT_PARAMETER).add(JSON_ARTIFACT_PATH, ARTIFACT_PATH_NONE).addJson(JSON_ITEMS, new JsonArray(new IJson[]{iJsonObject2})));
        iJsonObject.add(JSON_SUCCESS, false);
        iJsonObject.add(JSON_INTERRUPTED, false);
        iJsonObject.add(JSON_MOST_SEVERE_ERROR_LEVEL, BDVEJsonHelper.getJsonErrorLevel(EErrorLevel.ERROR));
        iJsonObject.addJson(JSON_RESULTS, jsonArray);
        iJsonObject.add(JSON_DURATION_MS, l);
    }

    @Nonnull
    @Nonempty
    public static String getArtifactPathType(@Nonnull IReadableResource iReadableResource) {
        if (iReadableResource instanceof ClassPathResource) {
            return "classpath";
        }
        if (iReadableResource instanceof FileSystemResource) {
            return "file";
        }
        if (iReadableResource instanceof URLResource) {
            return "url";
        }
        return "unknown";
    }

    public static void applyValidationResultList(@Nonnull IJsonObject iJsonObject, @Nonnull IValidationExecutorSet<?> iValidationExecutorSet, @Nonnull List<? extends ValidationResult> list, @Nonnull Locale locale, @Nonnegative long l, @Nullable MutableInt mutableInt, @Nullable MutableInt mutableInt2) {
        ValueEnforcer.notNull(iJsonObject, "Response");
        ValueEnforcer.notNull(iValidationExecutorSet, "VES");
        ValueEnforcer.notNull(list, "ValidationResultList");
        ValueEnforcer.notNull(locale, "DisplayLocale");
        ValueEnforcer.isGE0(l, "DurationMilliseconds");
        iJsonObject.addJson(JSON_VES, BDVEJsonHelper.getJsonVES(iValidationExecutorSet));
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        IErrorLevel iErrorLevel = EErrorLevel.LOWEST;
        JsonArray jsonArray = new JsonArray();
        for (ValidationResult validationResult : list) {
            JsonObject jsonObject = new JsonObject();
            if (validationResult.isIgnored()) {
                bl = true;
                jsonObject.add(JSON_SUCCESS, BDVEJsonHelper.getJsonTriState(ETriState.UNDEFINED));
            } else {
                jsonObject.add(JSON_SUCCESS, BDVEJsonHelper.getJsonTriState(validationResult.isSuccess()));
            }
            jsonObject.add(JSON_ARTIFACT_TYPE, validationResult.getValidationArtefact().getValidationArtefactType().getID());
            jsonObject.add(JSON_ARTIFACT_PATH_TYPE, BDVEJsonHelper.getArtifactPathType(validationResult.getValidationArtefact().getRuleResource()));
            jsonObject.add(JSON_ARTIFACT_PATH, validationResult.getValidationArtefact().getRuleResource().getPath());
            JsonArray jsonArray2 = new JsonArray();
            for (IError iError : validationResult.getErrorList()) {
                if (iError.getErrorLevel().isGT(iErrorLevel)) {
                    iErrorLevel = iError.getErrorLevel();
                }
                if (BDVEJsonHelper._isConsideredError(iError.getErrorLevel())) {
                    ++n2;
                } else if (BDVEJsonHelper._isConsideredWarning(iError.getErrorLevel())) {
                    ++n;
                }
                jsonArray2.add(BDVEJsonHelper.getJsonError(iError, locale));
            }
            jsonObject.addJson(JSON_ITEMS, jsonArray2);
            jsonArray.add(jsonObject);
        }
        iJsonObject.add(JSON_SUCCESS, iErrorLevel.isLE(EErrorLevel.WARN));
        iJsonObject.add(JSON_INTERRUPTED, bl);
        iJsonObject.add(JSON_MOST_SEVERE_ERROR_LEVEL, BDVEJsonHelper.getJsonErrorLevel(iErrorLevel));
        iJsonObject.addJson(JSON_RESULTS, jsonArray);
        iJsonObject.add(JSON_DURATION_MS, l);
        if (mutableInt != null) {
            mutableInt.set(n);
        }
        if (mutableInt2 != null) {
            mutableInt2.set(n2);
        }
    }

    @Nullable
    public static <T extends IValidationSource> IValidationExecutorSet<T> getAsVES(@Nonnull ValidationExecutorSetRegistry<T> validationExecutorSetRegistry, @Nullable IJsonObject iJsonObject) {
        ValueEnforcer.notNull(validationExecutorSetRegistry, "Registry");
        if (iJsonObject != null) {
            VESID vESID;
            String string;
            IJsonObject iJsonObject2 = iJsonObject.getAsObject(JSON_VES);
            if (iJsonObject2 == null) {
                iJsonObject2 = iJsonObject;
            }
            if (StringHelper.hasText(string = iJsonObject2.getAsString(JSON_VESID)) && (vESID = VESID.parseIDOrNull(string)) != null) {
                return validationExecutorSetRegistry.getOfID(vESID);
            }
        }
        return null;
    }

    @Nullable
    public static IReadableResource getAsValidationResource(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        if (StringHelper.hasNoText(string2)) {
            return null;
        }
        if ("file".equals(string)) {
            return new FileSystemResource(string2);
        }
        if ("url".equals(string)) {
            try {
                return new URLResource(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return new ClassPathResource(string2);
    }

    @Nullable
    public static ValidationResultList getAsValidationResultList(@Nullable IJsonObject iJsonObject) {
        if (iJsonObject == null) {
            return null;
        }
        IJsonArray iJsonArray = iJsonObject.getAsArray(JSON_RESULTS);
        if (iJsonArray == null) {
            return null;
        }
        ValidationResultList validationResultList = new ValidationResultList();
        for (IJson iJson : iJsonArray) {
            String string;
            IJsonObject iJsonObject2 = iJson.getAsObject();
            if (iJsonObject2 == null) continue;
            String string2 = iJsonObject2.getAsString(JSON_SUCCESS);
            ETriState eTriState = BDVEJsonHelper.getAsTriState(string2);
            if (eTriState == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Failed to resolve TriState '" + string2 + "'");
                continue;
            }
            String string3 = iJsonObject2.getAsString(JSON_ARTIFACT_TYPE);
            EValidationType eValidationType = EValidationType.getFromIDOrNull(string3);
            if (eValidationType == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Failed to resolve ValidationType '" + string3 + "'");
                continue;
            }
            String string4 = iJsonObject2.getAsString(JSON_ARTIFACT_PATH_TYPE);
            IReadableResource iReadableResource = BDVEJsonHelper.getAsValidationResource(string4, string = iJsonObject2.getAsString(JSON_ARTIFACT_PATH));
            if (iReadableResource == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Failed to resolve ValidationArtefact '" + string4 + "' with path '" + string + "'");
                continue;
            }
            ValidationArtefact validationArtefact = new ValidationArtefact(eValidationType, iReadableResource);
            if (eTriState.isUndefined()) {
                validationResultList.add(ValidationResult.createIgnoredResult(validationArtefact));
                continue;
            }
            IJsonArray iJsonArray2 = iJsonObject2.getAsArray(JSON_ITEMS);
            ErrorList errorList = new ErrorList();
            for (IJson iJson2 : iJsonArray2) {
                IJsonObject iJsonObject3 = iJson2.getAsObject();
                if (iJsonObject3 == null) continue;
                IError iError = BDVEJsonHelper.getAsIError(iJsonObject3);
                errorList.add(iError);
            }
            ValidationResult validationResult = new ValidationResult(validationArtefact, errorList);
            validationResultList.add(validationResult);
        }
        return validationResultList;
    }
}

