/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.json;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BDVERestoredException
extends Exception {
    private final String m_sClassName;
    private final String m_sMessage;
    private final ICommonsList<String> m_aStackTraceLines;

    public BDVERestoredException(@Nonnull String string, @Nullable String string2, @Nonnull ICommonsList<String> iCommonsList) {
        ValueEnforcer.notNull(string, "ClassName");
        ValueEnforcer.notNull(iCommonsList, "StackTraceLines");
        this.m_sClassName = string;
        this.m_sMessage = string2;
        this.m_aStackTraceLines = (ICommonsList)iCommonsList.getClone();
    }

    @Nonnull
    public String getClassName() {
        return this.m_sClassName;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.m_sMessage;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllStackTraceLines() {
        return (ICommonsList)this.m_aStackTraceLines.getClone();
    }

    @Nullable
    public IJsonObject getAsJson() {
        return new JsonObject().add("class", this.m_sClassName).addIfNotNull("message", this.m_sMessage).add("stackTrace", StringHelper.getImploded('\n', this.m_aStackTraceLines));
    }

    @Nullable
    public static BDVERestoredException createFromJson(@Nullable IJsonObject iJsonObject) {
        if (iJsonObject == null) {
            return null;
        }
        String string = iJsonObject.getAsString("class");
        String string2 = iJsonObject.getAsString("message");
        ICommonsList<String> iCommonsList = StringHelper.getExploded('\n', iJsonObject.getAsString("stackTrace"));
        if (string == null) {
            return null;
        }
        return new BDVERestoredException(string, string2, iCommonsList);
    }
}

