/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.helper;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsVector;
import com.helger.commons.collection.iterate.IIterableIterator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class VectorHelper {
    private VectorHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nonnegative int n) {
        return new CommonsVector(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector() {
        return new CommonsVector();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsVector<DSTTYPE> newVectorMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(collection.size());
        commonsVector.addAllMapped(collection, function);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsVector<DSTTYPE> newVectorMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty(SRCTYPEArray)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(SRCTYPEArray.length);
        commonsVector.addAllMapped(SRCTYPEArray, function);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(collection.size());
        commonsVector.addAll((Iterable<int>)collection, (Predicate<int>)predicate);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVectorPrefilled(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Elements");
        CommonsVector<int> commonsVector = VectorHelper.newVector(n);
        for (int i = 0; i < n; ++i) {
            commonsVector.add(ELEMENTTYPE);
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return new CommonsVector<ELEMENTTYPE>(ELEMENTTYPE);
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return VectorHelper.newVector(false);
        }
        return new CommonsVector<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        commonsVector.addAll(enumeration);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        commonsVector.addAll(iterator);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        commonsVector.addAll(iterable);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        return new CommonsVector<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return VectorHelper.newVector(false);
        }
        return VectorHelper.newVector(iIterableIterator.iterator());
    }
}

