/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.multimap;

import com.helger.collection.multimap.IMultiMapMapBased;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractMultiHashMapMapBased<KEYTYPE1, KEYTYPE2, VALUETYPE, MAPTYPE extends ICommonsMap<KEYTYPE2, VALUETYPE>>
extends CommonsHashMap<KEYTYPE1, MAPTYPE>
implements IMultiMapMapBased<KEYTYPE1, KEYTYPE2, VALUETYPE, MAPTYPE> {
    public AbstractMultiHashMapMapBased() {
    }

    public AbstractMultiHashMapMapBased(@Nonnull KEYTYPE1 KEYTYPE1, @Nonnull KEYTYPE2 KEYTYPE2, @Nullable VALUETYPE VALUETYPE) {
        this.putSingle(KEYTYPE1, KEYTYPE2, VALUETYPE);
    }

    public AbstractMultiHashMapMapBased(@Nullable KEYTYPE1 KEYTYPE1, @Nullable Map<? extends KEYTYPE2, ? extends VALUETYPE> map) {
        MAPTYPE MAPTYPE = this.createNewInnerMap();
        MAPTYPE.putAll(map);
        this.put(KEYTYPE1, MAPTYPE);
    }

    public AbstractMultiHashMapMapBased(@Nullable Map<? extends KEYTYPE1, ? extends Map<? extends KEYTYPE2, ? extends VALUETYPE>> map) {
        if (map != null) {
            for (Map.Entry<KEYTYPE1, Map<KEYTYPE2, VALUETYPE>> entry : map.entrySet()) {
                MAPTYPE MAPTYPE = this.createNewInnerMap();
                MAPTYPE.putAll(entry.getValue());
                this.put(entry.getKey(), MAPTYPE);
            }
        }
    }

    @Nonnull
    protected abstract MAPTYPE createNewInnerMap();

    @Override
    @Nonnull
    public MAPTYPE getOrCreate(@Nullable KEYTYPE1 KEYTYPE1) {
        return (MAPTYPE)this.computeIfAbsent(KEYTYPE1, object -> this.createNewInnerMap());
    }
}

