/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.ECollectionBaseType;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.PrimitiveCollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.state.EChange;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class CollectionHelper {
    private static final CollectionHelper s_aInstance = new CollectionHelper();

    private CollectionHelper() {
    }

    @Nullable
    public static ECollectionBaseType getCollectionBaseTypeOfClass(@Nullable Class<?> clazz) {
        if (clazz != null) {
            if (Set.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.SET;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.COLLECTION;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.MAP;
            }
            if (ClassHelper.isArrayClass(clazz)) {
                return ECollectionBaseType.ARRAY;
            }
            if (Iterator.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.ITERATOR;
            }
            if (Iterable.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.ITERABLE;
            }
            if (Enumeration.class.isAssignableFrom(clazz)) {
                return ECollectionBaseType.ENUMERATION;
            }
        }
        return null;
    }

    @Nullable
    public static ECollectionBaseType getCollectionBaseTypeOfObject(@Nullable Object object) {
        return object == null ? null : CollectionHelper.getCollectionBaseTypeOfClass(object.getClass());
    }

    public static boolean isCollectionClass(@Nullable Class<?> clazz) {
        return CollectionHelper.getCollectionBaseTypeOfClass(clazz) != null;
    }

    public static boolean isCollectionObject(@Nullable Object object) {
        return CollectionHelper.getCollectionBaseTypeOfObject(object) != null;
    }

    @Nonnull
    public static CommonsArrayList<?> getAsList(@Nonnull Object object) {
        ValueEnforcer.notNull(object, "Object");
        ECollectionBaseType eCollectionBaseType = CollectionHelper.getCollectionBaseTypeOfObject(object);
        if (eCollectionBaseType == null) {
            return CollectionHelper.newList(object);
        }
        switch (eCollectionBaseType) {
            case COLLECTION: {
                if (object instanceof CommonsArrayList) {
                    return (CommonsArrayList)object;
                }
                return CollectionHelper.newList((Collection)object);
            }
            case SET: {
                return CollectionHelper.newList((Set)object);
            }
            case MAP: {
                return CollectionHelper.newList(((Map)object).entrySet());
            }
            case ARRAY: {
                return CollectionHelper.newList((Object[])object);
            }
            case ITERATOR: {
                return CollectionHelper.newList((Iterator)object);
            }
            case ITERABLE: {
                return CollectionHelper.newList((Iterable)object);
            }
            case ENUMERATION: {
                return CollectionHelper.newList((Enumeration)object);
            }
        }
        throw new IllegalStateException("Unhandled collection type " + (Object)((Object)eCollectionBaseType) + "!");
    }

    @SafeVarargs
    @Nullable
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> List<ELEMENTTYPE> makeUnmodifiable(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ELEMENTTYPEArray == null ? null : Collections.unmodifiableList(CollectionHelper.newList(ELEMENTTYPEArray));
    }

    @Nullable
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> Collection<ELEMENTTYPE> makeUnmodifiable(@Nullable Collection<ELEMENTTYPE> collection) {
        return collection == null ? null : Collections.unmodifiableCollection(collection);
    }

    @Nullable
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> List<ELEMENTTYPE> makeUnmodifiable(@Nullable List<ELEMENTTYPE> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    @Nullable
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> makeUnmodifiable(@Nullable Set<ELEMENTTYPE> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    @Nullable
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    @Nullable
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> NavigableSet<ELEMENTTYPE> makeUnmodifiable(@Nullable NavigableSet<ELEMENTTYPE> navigableSet) {
        return navigableSet == null ? null : Collections.unmodifiableNavigableSet(navigableSet);
    }

    @Nullable
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE, VALUETYPE> NavigableMap<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable NavigableMap<KEYTYPE, VALUETYPE> navigableMap) {
        return navigableMap == null ? null : Collections.unmodifiableNavigableMap(navigableMap);
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> Collection<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Collection<ELEMENTTYPE> collection) {
        return collection == null ? Collections.emptyList() : Collections.unmodifiableCollection(collection);
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> List<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable List<ELEMENTTYPE> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Set<ELEMENTTYPE> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> NavigableSet<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable NavigableSet<ELEMENTTYPE> navigableSet) {
        return navigableSet == null ? Collections.emptyNavigableSet() : Collections.unmodifiableNavigableSet(navigableSet);
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> NavigableMap<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable NavigableMap<KEYTYPE, VALUETYPE> navigableMap) {
        return navigableMap == null ? Collections.emptyNavigableMap() : Collections.unmodifiableNavigableMap(navigableMap);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getDifference(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newSet(false);
        }
        if (CollectionHelper.isEmpty(collection2)) {
            return CollectionHelper.newSet(collection);
        }
        CommonsHashSet<ELEMENTTYPE> commonsHashSet = CollectionHelper.newSet(collection);
        commonsHashSet.removeAll(collection2);
        return commonsHashSet;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getIntersected(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newSet(false);
        }
        if (CollectionHelper.isEmpty(collection2)) {
            return CollectionHelper.newSet(false);
        }
        CommonsHashSet<ELEMENTTYPE> commonsHashSet = CollectionHelper.newSet(collection);
        commonsHashSet.retainAll(collection2);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nonnegative int n) {
        return new CommonsHashMap(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap() {
        return new CommonsHashMap();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCKEYTYPE, SRCVALUETYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE> newMapMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newMap(0);
        }
        return new CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE>(map, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE> newMapMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCTYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newMap(0);
        }
        return new CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE>(collection, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelper.newMap(map.size());
        commonsHashMap.putAll(map, predicate);
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelper.newMap(1);
        commonsHashMap.put(KEYTYPE, VALUETYPE);
        return commonsHashMap;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashMap<ELEMENTTYPE, ELEMENTTYPE> newMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return CollectionHelper.newMap(0);
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        CommonsHashMap commonsHashMap = CollectionHelper.newMap(ELEMENTTYPEArray.length / 2);
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            commonsHashMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        int n;
        int n2 = ArrayHelper.getSize(KEYTYPEArray);
        if (n2 != (n = ArrayHelper.getSize(VALUETYPEArray))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelper.newMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelper.newMap(n2);
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            commonsHashMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        int n;
        int n2 = CollectionHelper.getSize(collection);
        if (n2 != (n = CollectionHelper.getSize(collection2))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelper.newMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelper.newMap(n2);
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            commonsHashMap.put(iterator.next(), iterator2.next());
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newMap(0);
        }
        return new CommonsHashMap<KEYTYPE, VALUETYPE>(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (mapArray == null || mapArray.length == 0) {
            return CollectionHelper.newMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelper.newMap();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            commonsHashMap.putAll(map);
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelper.newMap(collection.size());
        commonsHashMap.putAll(collection);
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> newMap(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (CollectionHelper.isEmpty(iterable)) {
            return CollectionHelper.newMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelper.newMap();
        commonsHashMap.putAll(iterable);
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nonnegative int n) {
        return new CommonsLinkedHashMap(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap() {
        return new CommonsLinkedHashMap();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCKEYTYPE, SRCVALUETYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE> newOrderedMapMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newOrderedMap(0);
        }
        return new CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE>(map, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE> newOrderedMapMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCTYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newOrderedMap(0);
        }
        return new CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE>(collection, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelper.newOrderedMap(map.size());
        commonsLinkedHashMap.putAll(map, predicate);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelper.newOrderedMap(1);
        commonsLinkedHashMap.put(KEYTYPE, VALUETYPE);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashMap<ELEMENTTYPE, ELEMENTTYPE> newOrderedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return CollectionHelper.newOrderedMap(0);
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        CommonsLinkedHashMap commonsLinkedHashMap = CollectionHelper.newOrderedMap(ELEMENTTYPEArray.length / 2);
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            commonsLinkedHashMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        int n;
        int n2 = ArrayHelper.getSize(KEYTYPEArray);
        if (n2 != (n = ArrayHelper.getSize(VALUETYPEArray))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelper.newOrderedMap(n2);
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            commonsLinkedHashMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        int n;
        int n2 = CollectionHelper.getSize(collection);
        if (n2 != (n = CollectionHelper.getSize(collection2))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelper.newOrderedMap(n2);
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            commonsLinkedHashMap.put(iterator.next(), iterator2.next());
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newOrderedMap(0);
        }
        return new CommonsLinkedHashMap<KEYTYPE, VALUETYPE>(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (ArrayHelper.isEmpty(mapArray)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelper.newOrderedMap();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            commonsLinkedHashMap.putAll(map);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelper.newOrderedMap(collection.size());
        commonsLinkedHashMap.putAll(collection);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (CollectionHelper.isEmpty(iterable)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelper.newOrderedMap();
        commonsLinkedHashMap.putAll(iterable);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap() {
        return new CommonsTreeMap(Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCKEYTYPE, SRCVALUETYPE, DSTKEYTYPE extends Comparable<? super DSTKEYTYPE>, DSTVALUETYPE> CommonsTreeMap<DSTKEYTYPE, DSTVALUETYPE> newSortedMapMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, DSTKEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, DSTVALUETYPE> function2) {
        return new CommonsTreeMap<DSTKEYTYPE, DSTVALUETYPE>(map, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        commonsTreeMap.putAll(map, predicate);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        commonsTreeMap.put(KEYTYPE, VALUETYPE);
        return commonsTreeMap;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeMap<ELEMENTTYPE, ELEMENTTYPE> newSortedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return CollectionHelper.newSortedMap();
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        CommonsTreeMap commonsTreeMap = CollectionHelper.newSortedMap();
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            commonsTreeMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        if (ArrayHelper.isEmpty(KEYTYPEArray) && ArrayHelper.isEmpty(VALUETYPEArray)) {
            return CollectionHelper.newSortedMap();
        }
        if (ArrayHelper.getSize(KEYTYPEArray) != ArrayHelper.getSize(VALUETYPEArray)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            commonsTreeMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        if (CollectionHelper.isEmpty(collection) && CollectionHelper.isEmpty(collection2)) {
            return CollectionHelper.newSortedMap();
        }
        if (CollectionHelper.getSize(collection) != CollectionHelper.getSize(collection2)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            commonsTreeMap.put(iterator.next(), iterator2.next());
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        commonsTreeMap.putAll(map);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (mapArray == null || mapArray.length == 0) {
            return CollectionHelper.newSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            commonsTreeMap.putAll(map);
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        commonsTreeMap.putAll(collection);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (CollectionHelper.isEmpty(iterable)) {
            return CollectionHelper.newSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelper.newSortedMap();
        commonsTreeMap.putAll(iterable);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nonnegative int n) {
        return new CommonsHashSet<int>(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet() {
        return new CommonsHashSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsHashSet<DSTTYPE> newSetMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelper.newSet(collection.size());
        commonsHashSet.addAllMapped(collection, function);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsHashSet<DSTTYPE> newSetMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty(SRCTYPEArray)) {
            return CollectionHelper.newSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelper.newSet(SRCTYPEArray.length);
        commonsHashSet.addAllMapped(SRCTYPEArray, function);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelper.newSet(collection.size());
        commonsHashSet.addAll((Iterable<int>)collection, (Predicate<int>)predicate);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsHashSet<boolean> commonsHashSet = CollectionHelper.newSet(true);
        commonsHashSet.add(ELEMENTTYPE);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return CollectionHelper.newSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelper.newSet(ELEMENTTYPEArray.length);
        commonsHashSet.addAll(ELEMENTTYPEArray);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsHashSet<? extends ELEMENTTYPE> commonsHashSet = CollectionHelper.newSet();
        commonsHashSet.addAll(iterable);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newSet(false);
        }
        return new CommonsHashSet<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsHashSet<? extends ELEMENTTYPE> commonsHashSet = CollectionHelper.newSet();
        commonsHashSet.addAll(iterator);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return CollectionHelper.newSet(false);
        }
        return CollectionHelper.newSet(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> newSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsHashSet<? extends ELEMENTTYPE> commonsHashSet = CollectionHelper.newSet();
        commonsHashSet.addAll(enumeration);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> newEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, ELEMENTTYPE ... ELEMENTTYPEArray) {
        EnumSet<ELEMENTTYPE> enumSet = EnumSet.noneOf(clazz);
        if (ELEMENTTYPEArray != null) {
            Collections.addAll(enumSet, ELEMENTTYPEArray);
        }
        return enumSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> newEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, @Nullable Collection<ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return EnumSet.noneOf(clazz);
        }
        return EnumSet.copyOf(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> newEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, @Nullable EnumSet<ELEMENTTYPE> enumSet) {
        if (enumSet == null) {
            return EnumSet.noneOf(clazz);
        }
        return EnumSet.copyOf(enumSet);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet() {
        return new CommonsTreeSet(Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> CommonsTreeSet<DSTTYPE> newSortedSetMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        CommonsTreeSet<DSTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.addAllMapped(collection, function);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> CommonsTreeSet<DSTTYPE> newSortedSetMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        CommonsTreeSet<DSTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.addAllMapped(SRCTYPEArray, function);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        CommonsTreeSet<? super ELEMENTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.addAll((Iterable<? super ELEMENTTYPE>)collection, predicate);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="When using the constructor with the Comparator it works with null values!")
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsTreeSet<ELEMENTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.add(ELEMENTTYPE);
        return commonsTreeSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        CommonsTreeSet<ELEMENTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.addAll(ELEMENTTYPEArray);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsTreeSet<? extends ELEMENTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.addAll(iterable);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        CommonsTreeSet<ELEMENTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        if (CollectionHelper.isNotEmpty(collection)) {
            commonsTreeSet.addAll(collection);
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsTreeSet<? extends ELEMENTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.addAll(iterator);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return CollectionHelper.newSortedSet();
        }
        return CollectionHelper.newSortedSet(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> newSortedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsTreeSet<? extends ELEMENTTYPE> commonsTreeSet = CollectionHelper.newSortedSet();
        commonsTreeSet.addAll(enumeration);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nonnegative int n) {
        return new CommonsLinkedHashSet<int>(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet() {
        return new CommonsLinkedHashSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsLinkedHashSet<DSTTYPE> newOrderedSetMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelper.newOrderedSet(collection.size());
        commonsLinkedHashSet.addAllMapped(collection, function);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsLinkedHashSet<DSTTYPE> newOrderedSetMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty(SRCTYPEArray)) {
            return CollectionHelper.newOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelper.newOrderedSet(SRCTYPEArray.length);
        commonsLinkedHashSet.addAllMapped(SRCTYPEArray, function);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelper.newOrderedSet(collection.size());
        commonsLinkedHashSet.addAll((Iterable<int>)collection, (Predicate<int>)predicate);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsLinkedHashSet<boolean> commonsLinkedHashSet = CollectionHelper.newOrderedSet(true);
        commonsLinkedHashSet.add(ELEMENTTYPE);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return CollectionHelper.newOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelper.newOrderedSet(ELEMENTTYPEArray.length);
        Collections.addAll(commonsLinkedHashSet, ELEMENTTYPEArray);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        commonsLinkedHashSet.addAll(iterable);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newOrderedSet(false);
        }
        return new CommonsLinkedHashSet<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nonnull Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        commonsLinkedHashSet.addAll(iterator);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return CollectionHelper.newOrderedSet(false);
        }
        return CollectionHelper.newOrderedSet(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> newOrderedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        commonsLinkedHashSet.addAll(enumeration);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newListPrefilled(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Elements");
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(n);
        for (int i = 0; i < n; ++i) {
            commonsArrayList.add(ELEMENTTYPE);
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nonnegative int n) {
        return new CommonsArrayList<int>(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList() {
        return new CommonsArrayList();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        return CommonsArrayList.createFiltered(collection, predicate);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsArrayList<boolean> commonsArrayList = CollectionHelper.newList(true);
        commonsArrayList.add(ELEMENTTYPE);
        return commonsArrayList;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return CollectionHelper.newList(false);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelper.newList(ELEMENTTYPEArray.length);
        commonsArrayList.addAll(ELEMENTTYPEArray);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> newListMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        if (ArrayHelper.isEmpty(SRCTYPEArray)) {
            return CollectionHelper.newList(false);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelper.newList(SRCTYPEArray.length);
        commonsArrayList.addAllMapped(SRCTYPEArray, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> newListMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        CommonsArrayList<? extends DSTTYPE> commonsArrayList = CollectionHelper.newList();
        commonsArrayList.addAllMapped(iterable, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> newListMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newList(false);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelper.newList(collection.size());
        commonsArrayList.addAllMapped(collection, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> newListMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        CommonsArrayList<? extends DSTTYPE> commonsArrayList = CollectionHelper.newList();
        commonsArrayList.addAllMapped(iterable, predicate, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsArrayList<? extends ELEMENTTYPE> commonsArrayList = CollectionHelper.newList();
        commonsArrayList.addAll(enumeration);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsArrayList<? extends ELEMENTTYPE> commonsArrayList = CollectionHelper.newList();
        commonsArrayList.addAll(iterator);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsArrayList<? extends ELEMENTTYPE> commonsArrayList = CollectionHelper.newList();
        commonsArrayList.addAll(iterable);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newList(false);
        }
        return new CommonsArrayList<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> newList(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return CollectionHelper.newList(false);
        }
        return CollectionHelper.newList(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(iIterableIterator));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(iIterableIterator), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(iterator));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(iterator), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(iterable));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(iterable), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(collection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(collection), comparator);
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionHelper.getSortedInline(CollectionHelper.newList(ELEMENTTYPEArray), comparator);
    }

    @Nullable
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>, LISTTYPE extends List<ELEMENTTYPE>> LISTTYPE getSortedInline(@Nullable LISTTYPE LISTTYPE) {
        if (CollectionHelper.isNotEmpty(LISTTYPE)) {
            LISTTYPE.sort(null);
        }
        return LISTTYPE;
    }

    @Nullable
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, LISTTYPE extends List<ELEMENTTYPE>> LISTTYPE getSortedInline(@Nullable LISTTYPE LISTTYPE, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        ValueEnforcer.notNull(comparator, "Comparator");
        if (CollectionHelper.isNotEmpty(LISTTYPE)) {
            LISTTYPE.sort(comparator);
        }
        return LISTTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsArrayList<Map.Entry<KEYTYPE, VALUETYPE>> commonsArrayList = CollectionHelper.newList(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getKey));
        return CollectionHelper.newOrderedMap(commonsArrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super KEYTYPE> comparator) {
        ValueEnforcer.notNull(comparator, "KeyComparator");
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsArrayList<Map.Entry<KEYTYPE, VALUETYPE>> commonsArrayList = CollectionHelper.newList(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getKey, comparator));
        return CollectionHelper.newOrderedMap(commonsArrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsArrayList<Map.Entry<KEYTYPE, VALUETYPE>> commonsArrayList = CollectionHelper.newList(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getValue));
        return CollectionHelper.newOrderedMap(commonsArrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super VALUETYPE> comparator) {
        ValueEnforcer.notNull(comparator, "ValueComparator");
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newOrderedMap(0);
        }
        CommonsArrayList<Map.Entry<KEYTYPE, VALUETYPE>> commonsArrayList = CollectionHelper.newList(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getValue, comparator));
        return CollectionHelper.newOrderedMap(commonsArrayList);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getReverseList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.newList(false);
        }
        CommonsArrayList<ELEMENTTYPE> commonsArrayList = CollectionHelper.newList(collection);
        commonsArrayList.reverse();
        return commonsArrayList;
    }

    @Nullable
    @ReturnsMutableObject(value="semantics of this method")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, LISTTYPE extends List<ELEMENTTYPE>> LISTTYPE getReverseInlineList(@Nullable LISTTYPE LISTTYPE) {
        if (LISTTYPE == null) {
            return null;
        }
        Collections.reverse(LISTTYPE);
        return LISTTYPE;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEY, VALUE> ICommonsMap<KEY, VALUE> getFilteredMap(@Nullable ICommonsMap<KEY, VALUE> iCommonsMap, @Nullable Collection<? extends KEY> collection) {
        if (CollectionHelper.isEmpty(iCommonsMap) || CollectionHelper.isEmpty(collection)) {
            return null;
        }
        CommonsHashMap commonsHashMap = CollectionHelper.newMap();
        for (KEY KEY : collection) {
            if (!iCommonsMap.containsKey(KEY)) continue;
            commonsHashMap.put(KEY, iCommonsMap.get(KEY));
        }
        return commonsHashMap;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable List<ELEMENTTYPE> list) {
        return CollectionHelper.isEmpty(list) ? null : (ELEMENTTYPE)list.get(0);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Collection<ELEMENTTYPE> collection) {
        return CollectionHelper.isEmpty(collection) ? null : (ELEMENTTYPE)collection.iterator().next();
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Iterable<ELEMENTTYPE> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<ELEMENTTYPE> iterator = iterable.iterator();
        return iterator.hasNext() ? (ELEMENTTYPE)iterator.next() : null;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeFirstElement(@Nullable List<ELEMENTTYPE> list) {
        return CollectionHelper.isEmpty(list) ? null : (ELEMENTTYPE)list.remove(0);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable List<ELEMENTTYPE> list) {
        int n = CollectionHelper.getSize(list);
        return n == 0 ? null : (ELEMENTTYPE)list.get(n - 1);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Collection<ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return null;
        }
        ELEMENTTYPE ELEMENTTYPE = null;
        for (ELEMENTTYPE ELEMENTTYPE2 : collection) {
            ELEMENTTYPE = ELEMENTTYPE2;
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Iterable<ELEMENTTYPE> iterable) {
        if (iterable == null) {
            return null;
        }
        ELEMENTTYPE ELEMENTTYPE = null;
        for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
            ELEMENTTYPE = ELEMENTTYPE2;
        }
        return ELEMENTTYPE;
    }

    @Nonnull
    public static EChange removeAtIndex(@Nullable List<?> list, int n) {
        if (list == null || n < 0 || n >= list.size()) {
            return EChange.UNCHANGED;
        }
        list.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeAndReturnElementAtIndex(@Nullable List<ELEMENTTYPE> list, int n) {
        if (list == null || n < 0 || n >= list.size()) {
            return null;
        }
        return list.remove(n);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeLastElement(@Nullable List<ELEMENTTYPE> list) {
        int n = CollectionHelper.getSize(list);
        return n == 0 ? null : (ELEMENTTYPE)list.remove(n - 1);
    }

    public static boolean isEmpty(@Nullable Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Iterable<?> iterable) {
        return iterable != null && iterable.iterator().hasNext();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    @Nonnegative
    public static int getSize(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    @Nonnegative
    public static int getSize(@Nullable Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    @Nonnegative
    public static int getSize(@Nullable Iterable<?> iterable) {
        return iterable == null ? 0 : IteratorHelper.getSize(iterable.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable Enumeration<?> enumeration) {
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
        }
        return n;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        int n = CollectionHelper.getSize(collection);
        if (n == 0) {
            return CollectionHelper.newList(collection2);
        }
        int n2 = CollectionHelper.getSize(collection2);
        if (n2 == 0) {
            return CollectionHelper.newList(collection);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelper.newList(n + n2);
        commonsArrayList.addAll(collection);
        commonsArrayList.addAll(collection2);
        return commonsArrayList;
    }

    @Nullable
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> collection, ELEMENTTYPE ... ELEMENTTYPEArray) {
        int n = CollectionHelper.getSize(collection);
        if (n == 0) {
            return CollectionHelper.newList(ELEMENTTYPEArray);
        }
        int n2 = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n2 == 0) {
            return CollectionHelper.newList(collection);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelper.newList(n + n2);
        commonsArrayList.addAll(collection);
        Collections.addAll(commonsArrayList, ELEMENTTYPEArray);
        return commonsArrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getConcatenatedList(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        int n = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n == 0) {
            return CollectionHelper.newList(collection);
        }
        int n2 = CollectionHelper.getSize(collection);
        if (n2 == 0) {
            return CollectionHelper.newList(ELEMENTTYPEArray);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelper.newList(n + n2);
        Collections.addAll(commonsArrayList, ELEMENTTYPEArray);
        commonsArrayList.addAll(collection);
        return commonsArrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        int n = CollectionHelper.getSize(collection);
        if (n == 0) {
            return CollectionHelper.newSet(collection2);
        }
        int n2 = CollectionHelper.getSize(collection2);
        if (n2 == 0) {
            return CollectionHelper.newSet(collection);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelper.newSet(n + n2);
        commonsHashSet.addAll(collection);
        commonsHashSet.addAll(collection2);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, ELEMENTTYPE ... ELEMENTTYPEArray) {
        int n = CollectionHelper.getSize(collection);
        if (n == 0) {
            return CollectionHelper.newSet(ELEMENTTYPEArray);
        }
        int n2 = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n2 == 0) {
            return CollectionHelper.newSet(collection);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelper.newSet(n + n2);
        commonsHashSet.addAll(collection);
        Collections.addAll(commonsHashSet, ELEMENTTYPEArray);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getConcatenatedSet(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        int n = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n == 0) {
            return CollectionHelper.newSet(collection);
        }
        int n2 = CollectionHelper.getSize(collection);
        if (n2 == 0) {
            return CollectionHelper.newSet(ELEMENTTYPEArray);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelper.newSet(n + n2);
        Collections.addAll(commonsHashSet, ELEMENTTYPEArray);
        commonsHashSet.addAll(collection);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE COLLTYPE, ELEMENTTYPE ... ELEMENTTYPEArray) {
        ValueEnforcer.notNull(COLLTYPE, "Container");
        if (ELEMENTTYPEArray != null) {
            Collections.addAll(COLLTYPE, ELEMENTTYPEArray);
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE COLLTYPE, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        ValueEnforcer.notNull(COLLTYPE, "Container");
        if (collection != null) {
            COLLTYPE.addAll(collection);
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEY, VALUE> ICommonsMap<KEY, VALUE> getCombinedMap(@Nullable Map<KEY, VALUE> map, @Nullable Map<KEY, VALUE> map2) {
        if (CollectionHelper.isEmpty(map)) {
            return CollectionHelper.newMap(map2);
        }
        if (CollectionHelper.isEmpty(map2)) {
            return CollectionHelper.newMap(map);
        }
        CommonsHashMap<KEY, VALUE> commonsHashMap = new CommonsHashMap<KEY, VALUE>(map);
        commonsHashMap.putAll(map2);
        return commonsHashMap;
    }

    @Nullable
    @ReturnsMutableCopy
    public static CommonsArrayList<?> newObjectListFromArray(@Nullable Object object, @Nonnull Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((boolean[])object);
        }
        if (clazz == Byte.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((byte[])object);
        }
        if (clazz == Character.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((char[])object);
        }
        if (clazz == Double.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((double[])object);
        }
        if (clazz == Float.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((float[])object);
        }
        if (clazz == Integer.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((int[])object);
        }
        if (clazz == Long.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((long[])object);
        }
        if (clazz == Short.TYPE) {
            return PrimitiveCollectionHelper.newPrimitiveList((short[])object);
        }
        Object[] objectArray = (Object[])object;
        if (ArrayHelper.isEmpty(objectArray)) {
            return null;
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelper.newList(objectArray.length);
        Collections.addAll(commonsArrayList, objectArray);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSubList(@Nullable List<ELEMENTTYPE> list, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0(n, "StartIndex");
        ValueEnforcer.isGE0(n2, "SectionLength");
        int n3 = CollectionHelper.getSize(list);
        if (n3 == 0 || n >= n3) {
            return CollectionHelper.newList(false);
        }
        int n4 = n + n2;
        if (n4 > n3) {
            n4 = n3;
        }
        return CollectionHelper.newList(list.subList(n, n4));
    }

    public static <ELEMENTTYPE> boolean contains(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (CollectionHelper.isEmpty(collection)) {
            return false;
        }
        return collection.contains(ELEMENTTYPE);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE findFirst(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.findFirst(iterable, predicate, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE findFirst(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (predicate == null) {
            return CollectionHelper.getFirstElement(iterable);
        }
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
                if (!predicate.test(ELEMENTTYPE2)) continue;
                return ELEMENTTYPE2;
            }
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE, DSTTYPE> DSTTYPE findFirstMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        return CollectionHelper.findFirstMapped(iterable, predicate, function, null);
    }

    @Nullable
    public static <ELEMENTTYPE, DSTTYPE> DSTTYPE findFirstMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        ValueEnforcer.notNull(function, "Mapper");
        if (CollectionHelper.isNotEmpty(iterable)) {
            if (predicate == null) {
                return function.apply(CollectionHelper.getFirstElement(iterable));
            }
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                return function.apply(ELEMENTTYPE);
            }
        }
        return DSTTYPE;
    }

    public static <ELEMENTTYPE> void findAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        if (CollectionHelper.isNotEmpty(iterable)) {
            if (predicate == null) {
                iterable.forEach(consumer);
            } else {
                for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                    if (!predicate.test(ELEMENTTYPE)) continue;
                    consumer.accept(ELEMENTTYPE);
                }
            }
        }
    }

    public static <SRCTYPE, DSTTYPE> void findAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        ValueEnforcer.notNull(function, "Mapper");
        ValueEnforcer.notNull(consumer, "Consumer");
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (SRCTYPE SRCTYPE : iterable) {
                consumer.accept(function.apply(SRCTYPE));
            }
        }
    }

    public static <SRCTYPE, DSTTYPE> void findAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        ValueEnforcer.notNull(function, "Mapper");
        ValueEnforcer.notNull(consumer, "Consumer");
        if (predicate == null) {
            CollectionHelper.findAllMapped(iterable, function, consumer);
        } else if (CollectionHelper.isNotEmpty(iterable)) {
            for (SRCTYPE SRCTYPE : iterable) {
                if (!predicate.test(SRCTYPE)) continue;
                consumer.accept(function.apply(SRCTYPE));
            }
        }
    }

    public static <SRCTYPE, DSTTYPE> void findAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nullable Predicate<? super DSTTYPE> predicate, @Nonnull Consumer<? super DSTTYPE> consumer) {
        ValueEnforcer.notNull(function, "Mapper");
        ValueEnforcer.notNull(consumer, "Consumer");
        if (predicate == null) {
            CollectionHelper.findAllMapped(iterable, function, consumer);
        } else if (CollectionHelper.isNotEmpty(iterable)) {
            for (SRCTYPE SRCTYPE : iterable) {
                DSTTYPE DSTTYPE = function.apply(SRCTYPE);
                if (!predicate.test(DSTTYPE)) continue;
                consumer.accept(DSTTYPE);
            }
        }
    }

    @Nonnegative
    public static <ELEMENTTYPE> int getCount(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.getSize(iterable);
        }
        int n = 0;
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static <ELEMENTTYPE> int getCount(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.getSize(collection);
        }
        int n = 0;
        if (CollectionHelper.isNotEmpty(collection)) {
            for (ELEMENTTYPE ELEMENTTYPE : collection) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                ++n;
            }
        }
        return n;
    }

    public static <ELEMENTTYPE> boolean containsAny(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.isNotEmpty(iterable);
        }
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static <ELEMENTTYPE> boolean containsNone(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.isEmpty(iterable);
        }
        for (ELEMENTTYPE ELEMENTTYPE : iterable) {
            if (!predicate.test(ELEMENTTYPE)) continue;
            return false;
        }
        return true;
    }

    public static <ELEMENTTYPE> boolean containsOnly(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(iterable)) {
            return false;
        }
        if (predicate == null) {
            return CollectionHelper.isNotEmpty(iterable);
        }
        for (ELEMENTTYPE ELEMENTTYPE : iterable) {
            if (predicate.test(ELEMENTTYPE)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAnyNullElement(@Nullable Iterable<?> iterable) {
        return CollectionHelper.containsAny(iterable, Objects::isNull);
    }

    public static boolean containsOnlyNullElements(@Nullable Iterable<?> iterable) {
        return CollectionHelper.containsOnly(iterable, Objects::isNull);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getAtIndex(@Nullable List<? extends ELEMENTTYPE> list, int n) {
        return CollectionHelper.getAtIndex(list, n, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getAtIndex(@Nullable List<? extends ELEMENTTYPE> list, int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return list != null && n >= 0 && n < list.size() ? list.get(n) : ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnegative int n) {
        return CollectionHelper.getAtIndex(iterable, n, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (n >= 0) {
            int n2 = 0;
            for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
                if (n2 == n) {
                    return ELEMENTTYPE2;
                }
                ++n2;
            }
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n) {
        return CollectionHelper.getAtIndex(iterable, predicate, n, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getAtIndex(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (predicate == null) {
            return CollectionHelper.getAtIndex(iterable, n, ELEMENTTYPE);
        }
        if (n >= 0) {
            int n2 = 0;
            for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
                if (!predicate.test(ELEMENTTYPE2)) continue;
                if (n2 == n) {
                    return ELEMENTTYPE2;
                }
                ++n2;
            }
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <SRCTYPE, DSTTYPE> DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnegative int n, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        return CollectionHelper.getAtIndexMapped(iterable, n, function, null);
    }

    @Nullable
    public static <SRCTYPE, DSTTYPE> DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnegative int n, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        if (n >= 0) {
            int n2 = 0;
            for (SRCTYPE SRCTYPE : iterable) {
                if (n2 == n) {
                    return function.apply(SRCTYPE);
                }
                ++n2;
            }
        }
        return DSTTYPE;
    }

    @Nullable
    public static <SRCTYPE, DSTTYPE> DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnegative int n, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        return CollectionHelper.getAtIndexMapped(iterable, predicate, n, function, null);
    }

    @Nullable
    public static <SRCTYPE, DSTTYPE> DSTTYPE getAtIndexMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnegative int n, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        if (predicate == null) {
            return CollectionHelper.getAtIndexMapped(iterable, n, function, DSTTYPE);
        }
        if (n >= 0) {
            int n2 = 0;
            for (SRCTYPE SRCTYPE : iterable) {
                if (!predicate.test(SRCTYPE)) continue;
                if (n2 == n) {
                    return function.apply(SRCTYPE);
                }
                ++n2;
            }
        }
        return DSTTYPE;
    }
}

