/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.IConfigurationSource;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@MustImplementEqualsAndHashcode
@Immutable
public abstract class AbstractConfigurationSource
implements IConfigurationSource {
    private final EConfigSourceType m_eSourceType;
    private final int m_nPriority;

    protected AbstractConfigurationSource(@Nonnull EConfigSourceType eConfigSourceType, int n) {
        ValueEnforcer.notNull(eConfigSourceType, "Type");
        this.m_eSourceType = eConfigSourceType;
        this.m_nPriority = n;
    }

    @Override
    @Nonnull
    public final EConfigSourceType getSourceType() {
        return this.m_eSourceType;
    }

    @Override
    public final int getPriority() {
        return this.m_nPriority;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractConfigurationSource abstractConfigurationSource = (AbstractConfigurationSource)object;
        return this.m_eSourceType.equals(abstractConfigurationSource.m_eSourceType) && this.m_nPriority == abstractConfigurationSource.m_nPriority;
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eSourceType)).append(this.m_nPriority).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("SourceType", this.m_eSourceType).append("Priority", this.m_nPriority).getToString();
    }
}

