/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
extends CSSWritableList<CSSDeclaration>
implements IHasCSSDeclarations<CSSDeclarationList> {
    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.add(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSDeclarationList addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.add(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.removeObject(cSSDeclaration);
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int n) {
        return this.removeAtIndex(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.removeAll();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.getClone();
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return (CSSDeclaration)this.getAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSDeclarationList setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.set(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.getCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.findFirst(cSSDeclaration -> cSSDeclaration.hasProperty(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        CommonsArrayList<CSSDeclaration> commonsArrayList = new CommonsArrayList<CSSDeclaration>();
        if (StringHelper.hasText(string)) {
            this.findAll(cSSDeclaration -> cSSDeclaration.hasProperty(string), commonsArrayList::add);
        }
        return commonsArrayList;
    }
}

