/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSURI;
import com.helger.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberTermURI
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private CSSURI m_aURI;

    public CSSExpressionMemberTermURI(@Nonnull String string) {
        this(new CSSURI(string));
    }

    public CSSExpressionMemberTermURI(@Nonnull CSSURI cSSURI) {
        this.setURI(cSSURI);
    }

    @Nonnull
    public CSSURI getURI() {
        return this.m_aURI;
    }

    @Nonnull
    @Nonempty
    public String getURIString() {
        return this.m_aURI.getURI();
    }

    @Nonnull
    public CSSExpressionMemberTermURI setURI(@Nonnull CSSURI cSSURI) {
        this.m_aURI = ValueEnforcer.notNull(cSSURI, "URI");
        return this;
    }

    @Nonnull
    public CSSExpressionMemberTermURI setURIString(@Nonnull String string) {
        this.m_aURI.setURI(string);
        return this;
    }

    @Override
    @Nonnull
    public CSSExpressionMemberTermURI getClone() {
        return new CSSExpressionMemberTermURI(this.m_aURI);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_aURI.getAsCSSString(iCSSWriterSettings, n);
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aURI.setSourceLocation(cSSSourceLocation);
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aURI.getSourceLocation();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberTermURI cSSExpressionMemberTermURI = (CSSExpressionMemberTermURI)object;
        return this.m_aURI.equals(cSSExpressionMemberTermURI.m_aURI);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("URI", this.m_aURI).getToString();
    }
}

