/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSRGB;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSRGBA
implements ICSSWriteable,
ICSSColor,
ICloneable<CSSRGBA> {
    private String m_sRed;
    private String m_sGreen;
    private String m_sBlue;
    private String m_sOpacity;

    public CSSRGBA(@Nonnull CSSRGBA cSSRGBA) {
        this(cSSRGBA.getRed(), cSSRGBA.getGreen(), cSSRGBA.getBlue(), cSSRGBA.getOpacity());
    }

    public CSSRGBA(@Nonnull CSSRGB cSSRGB, float f) {
        this(cSSRGB, Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSRGBA(@Nonnull CSSRGB cSSRGB, @Nonnull @Nonempty String string) {
        this(cSSRGB.getRed(), cSSRGB.getGreen(), cSSRGB.getBlue(), string);
    }

    public CSSRGBA(int n, int n2, int n3, float f) {
        this(Integer.toString(CSSColorHelper.getRGBValue(n)), Integer.toString(CSSColorHelper.getRGBValue(n2)), Integer.toString(CSSColorHelper.getRGBValue(n3)), Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSRGBA(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4) {
        this.setRed(string);
        this.setGreen(string2);
        this.setBlue(string3);
        this.setOpacity(string4);
    }

    @Nonnull
    @Nonempty
    public String getRed() {
        return this.m_sRed;
    }

    @Nonnull
    public CSSRGBA setRed(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Red");
        this.m_sRed = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getGreen() {
        return this.m_sGreen;
    }

    @Nonnull
    public CSSRGBA setGreen(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Green");
        this.m_sGreen = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getBlue() {
        return this.m_sBlue;
    }

    @Nonnull
    public CSSRGBA setBlue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Blue");
        this.m_sBlue = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getOpacity() {
        return this.m_sOpacity;
    }

    @Nonnull
    public CSSRGBA setOpacity(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Opacity");
        this.m_sOpacity = string;
        return this;
    }

    @Nonnull
    public CSSRGB getAsRGB() {
        return new CSSRGB(this.m_sRed, this.m_sGreen, this.m_sBlue);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "rgba(" + this.m_sRed + ',' + this.m_sGreen + ',' + this.m_sBlue + ',' + this.m_sOpacity + ")";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.getAsString();
    }

    @Override
    @Nonnull
    public CSSRGBA getClone() {
        return new CSSRGBA(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSRGBA cSSRGBA = (CSSRGBA)object;
        return this.m_sRed.equals(cSSRGBA.m_sRed) && this.m_sGreen.equals(cSSRGBA.m_sGreen) && this.m_sBlue.equals(cSSRGBA.m_sBlue) && this.m_sOpacity.equals(cSSRGBA.m_sOpacity);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sRed).append(this.m_sGreen).append(this.m_sBlue).append(this.m_sOpacity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("red", this.m_sRed).append("green", this.m_sGreen).append("blue", this.m_sBlue).append("opacity", this.m_sOpacity).getToString();
    }
}

