/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSRect
implements ICSSWriteable {
    private String m_sTop;
    private String m_sRight;
    private String m_sBottom;
    private String m_sLeft;

    public CSSRect(@Nonnull CSSRect cSSRect) {
        this(cSSRect.getTop(), cSSRect.getRight(), cSSRect.getBottom(), cSSRect.getLeft());
    }

    public CSSRect(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4) {
        this.setTop(string);
        this.setRight(string2);
        this.setBottom(string3);
        this.setLeft(string4);
    }

    @Nonnull
    @Nonempty
    public String getTop() {
        return this.m_sTop;
    }

    @Nonnull
    public CSSRect setTop(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Top");
        this.m_sTop = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getRight() {
        return this.m_sRight;
    }

    @Nonnull
    public CSSRect setRight(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Right");
        this.m_sRight = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getBottom() {
        return this.m_sBottom;
    }

    @Nonnull
    public CSSRect setBottom(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Bottom");
        this.m_sBottom = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getLeft() {
        return this.m_sLeft;
    }

    @Nonnull
    public CSSRect setLeft(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Left");
        this.m_sLeft = string;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return "rect(" + this.m_sTop + ',' + this.m_sRight + ',' + this.m_sBottom + ',' + this.m_sLeft + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSRect cSSRect = (CSSRect)object;
        return this.m_sTop.equals(cSSRect.m_sTop) && this.m_sRight.equals(cSSRect.m_sRight) && this.m_sBottom.equals(cSSRect.m_sBottom) && this.m_sLeft.equals(cSSRect.m_sLeft);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sTop).append(this.m_sRight).append(this.m_sBottom).append(this.m_sLeft).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("top", this.m_sTop).append("right", this.m_sRight).append("bottom", this.m_sBottom).append("left", this.m_sLeft).getToString();
    }
}

