/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSUnknownRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private String m_sParameterList;
    private String m_sBody;
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, '@');
    }

    public CSSUnknownRule(@Nonnull @Nonempty String string) {
        if (!CSSUnknownRule.isValidDeclaration(string)) {
            throw new IllegalArgumentException("declaration");
        }
        this.m_sDeclaration = string;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    public CSSUnknownRule setParameterList(@Nullable String string) {
        this.m_sParameterList = StringHelper.trim(string);
        return this;
    }

    @Nullable
    public String getParameterList() {
        return this.m_sParameterList;
    }

    @Nonnull
    public CSSUnknownRule setBody(@Nullable String string) {
        this.m_sBody = StringHelper.trim(string);
        return this;
    }

    @Nullable
    public String getBody() {
        return this.m_sBody;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteUnknownRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(this.m_sDeclaration);
        if (StringHelper.hasText(this.m_sParameterList)) {
            stringBuilder.append(' ').append(this.m_sParameterList);
        }
        if (StringHelper.hasNoText(this.m_sBody)) {
            stringBuilder.append(bl ? "{}" : " {}" + iCSSWriterSettings.getNewLineString());
        } else {
            stringBuilder.append(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString());
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append(this.m_sBody);
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getNewLineString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSUnknownRule cSSUnknownRule = (CSSUnknownRule)object;
        return this.m_sDeclaration.equals(cSSUnknownRule.m_sDeclaration) && EqualsHelper.equals(this.m_sParameterList, cSSUnknownRule.m_sParameterList) && EqualsHelper.equals(this.m_sBody, cSSUnknownRule.m_sBody);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sDeclaration).append(this.m_sParameterList).append(this.m_sBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("declaration", this.m_sDeclaration).appendIfNotNull("parameterList", this.m_sParameterList).appendIfNotNull("body", this.m_sBody).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

