/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.shorthand;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.property.ICSSProperty;
import javax.annotation.Nonnull;

public final class CSSPropertyWithDefaultValue {
    private final ICSSProperty m_aProperty;
    private final String m_sDefaultValue;

    public CSSPropertyWithDefaultValue(@Nonnull ICSSProperty iCSSProperty, @Nonnull String string) {
        this.m_aProperty = ValueEnforcer.notNull(iCSSProperty, "Property");
        this.m_sDefaultValue = ValueEnforcer.notNull(string, "DefaultValue");
        if (!iCSSProperty.isValidValue(string)) {
            throw new IllegalArgumentException("Default value '" + string + "' does not match property " + iCSSProperty);
        }
    }

    @Nonnull
    public ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Nonnull
    public String getDefaultValue() {
        return this.m_sDefaultValue;
    }

    public String toString() {
        return new ToStringGenerator(this).append("property", this.m_aProperty).append("defaultValue", this.m_sDefaultValue).getToString();
    }
}

