/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.media;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaList
implements ICSSMediaList,
ICloneable<CSSMediaList> {
    public static final String DEFAULT_MEDIA_STRING_SEPARATOR = ", ";
    private final ICommonsOrderedSet<ECSSMedium> m_aMedia = new CommonsLinkedHashSet<ECSSMedium>();

    public CSSMediaList() {
    }

    public CSSMediaList(@Nonnull ECSSMedium eCSSMedium) {
        this.addMedium(eCSSMedium);
    }

    public CSSMediaList(ECSSMedium ... eCSSMediumArray) {
        if (eCSSMediumArray != null) {
            for (ECSSMedium eCSSMedium : eCSSMediumArray) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    public CSSMediaList(@Nullable Iterable<ECSSMedium> iterable) {
        if (iterable != null) {
            for (ECSSMedium eCSSMedium : iterable) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    public CSSMediaList(@Nonnull ICSSMediaList iCSSMediaList) {
        ValueEnforcer.notNull(iCSSMediaList, "Other");
        this.m_aMedia.addAll(iCSSMediaList.getAllMedia());
    }

    public CSSMediaList(@Nonnull CSSMediaList cSSMediaList) {
        ValueEnforcer.notNull(cSSMediaList, "Other");
        this.m_aMedia.addAll(cSSMediaList.m_aMedia);
    }

    @Nonnull
    public CSSMediaList addMedium(@Nonnull ECSSMedium eCSSMedium) {
        ValueEnforcer.notNull(eCSSMedium, "Medium");
        this.m_aMedia.add(eCSSMedium);
        return this;
    }

    @Nonnull
    public CSSMediaList addMedia(ECSSMedium ... eCSSMediumArray) {
        ValueEnforcer.notNull(eCSSMediumArray, "MediaList");
        this.m_aMedia.addAll((ECSSMedium[])eCSSMediumArray);
        return this;
    }

    @Nonnull
    public CSSMediaList addMedia(@Nonnull ICSSMediaList iCSSMediaList) {
        ValueEnforcer.notNull(iCSSMediaList, "MediaList");
        this.m_aMedia.addAll(iCSSMediaList.getAllMedia());
        return this;
    }

    @Nonnull
    public CSSMediaList addMedia(@Nonnull Iterable<ECSSMedium> iterable) {
        ValueEnforcer.notNull(iterable, "MediaList");
        this.m_aMedia.addAll(iterable);
        return this;
    }

    @Nonnull
    public EChange removeMedium(@Nullable ECSSMedium eCSSMedium) {
        return this.m_aMedia.removeObject(eCSSMedium);
    }

    @Nonnull
    public EChange removeAllMedia() {
        return this.m_aMedia.removeAll();
    }

    @Override
    @Nonnegative
    public int getMediaCount() {
        return this.m_aMedia.size();
    }

    @Override
    public boolean hasNoMedia() {
        return this.m_aMedia.isEmpty();
    }

    @Override
    public boolean containsMedium(@Nullable ECSSMedium eCSSMedium) {
        return this.m_aMedia.contains(eCSSMedium);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ECSSMedium> getAllMedia() {
        return this.m_aMedia.getClone();
    }

    @Override
    @Nonnull
    public String getMediaString(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Separator");
        if (this.m_aMedia.isEmpty()) {
            return "";
        }
        return StringHelper.getImplodedMapped(string, this.m_aMedia, ECSSMedium::getName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CSSMediaList getClone() {
        return new CSSMediaList(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaList cSSMediaList = (CSSMediaList)object;
        return this.m_aMedia.equals(cSSMediaList.m_aMedia);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMedia)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("media", this.m_aMedia).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CSSMediaList createOnDemand(@Nullable ICSSMediaList iCSSMediaList) {
        return iCSSMediaList == null ? new CSSMediaList() : new CSSMediaList(iCSSMediaList);
    }
}

