/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public AbstractCSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, stringArray);
        ValueEnforcer.isGT0(n, "MinArgCount");
        ValueEnforcer.isGT0(n2, "MaxArgCount");
        ValueEnforcer.isTrue(n <= n2, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    public AbstractCSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, iterable);
        ValueEnforcer.isGT0(n, "MinArgCount");
        ValueEnforcer.isGT0(n2, "MaxArgCount");
        ValueEnforcer.isTrue(n <= n2, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    @Override
    public final int getMinimumArgumentCount() {
        return this.m_nMinArgCount;
    }

    @Override
    public final int getMaximumArgumentCount() {
        return this.m_nMaxArgCount;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractCSSPropertyEnums abstractCSSPropertyEnums = (AbstractCSSPropertyEnums)object;
        return this.m_nMinArgCount == abstractCSSPropertyEnums.m_nMinArgCount && this.m_nMaxArgCount == abstractCSSPropertyEnums.m_nMaxArgCount;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_nMinArgCount).append(this.m_nMaxArgCount).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("MinArgCount", this.m_nMinArgCount).append("MaxArgCount", this.m_nMaxArgCount).getToString();
    }
}

