/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.regex.RegExHelper;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSPropertyEnums;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnums
extends AbstractCSSPropertyEnums {
    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, n, n2, stringArray);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, stringArray);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, n, n2, stringArray);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, n, n2, iterable);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, iterable);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, n, n2, iterable);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray(string.trim(), "\\s+");
        if (stringArray.length < this.getMinimumArgumentCount() || stringArray.length > this.getMaximumArgumentCount()) {
            return false;
        }
        for (String string2 : stringArray) {
            if (super.isValidValue(string2.trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnums(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyEnums(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), this.directGetEnumValues());
    }
}

