/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSProperty;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyNumber
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;

    public CSSPropertyNumber(@Nonnull ECSSProperty eCSSProperty, boolean bl) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, bl);
    }

    public CSSPropertyNumber(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl) {
        this(eCSSProperty, null, iCSSPropertyCustomizer, bl);
    }

    public CSSPropertyNumber(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        this.m_bWithPercentage = bl;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        return super.isValidValue(string) || CSSNumberHelper.isValueWithUnit(string, this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyNumber getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyNumber(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyNumber getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyNumber(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.m_bWithPercentage);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyNumber cSSPropertyNumber = (CSSPropertyNumber)object;
        return this.m_bWithPercentage == cSSPropertyNumber.m_bWithPercentage;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_bWithPercentage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("withPercentage", this.m_bWithPercentage).getToString();
    }
}

