/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.functional.IThrowingSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAutoSaveAware {
    public boolean isAutoSaveEnabled();

    public void beginWithoutAutoSave();

    public void endWithoutAutoSave();

    default public void performWithoutAutoSave(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        this.beginWithoutAutoSave();
        try {
            runnable.run();
        }
        finally {
            this.endWithoutAutoSave();
        }
    }

    @Nullable
    default public <RETURNTYPE> RETURNTYPE performWithoutAutoSave(@Nonnull Supplier<RETURNTYPE> supplier) {
        ValueEnforcer.notNull(supplier, "Callable");
        this.beginWithoutAutoSave();
        try {
            RETURNTYPE RETURNTYPE = supplier.get();
            return RETURNTYPE;
        }
        finally {
            this.endWithoutAutoSave();
        }
    }

    default public <EXTYPE extends Exception> void performWithoutAutoSaveThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        this.beginWithoutAutoSave();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.endWithoutAutoSave();
        }
    }

    @Nullable
    default public <RETURNTYPE, EXTYPE extends Exception> RETURNTYPE performWithoutAutoSaveThrowing(@Nonnull IThrowingSupplier<RETURNTYPE, EXTYPE> iThrowingSupplier) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingSupplier, "Callable");
        this.beginWithoutAutoSave();
        try {
            RETURNTYPE RETURNTYPE = iThrowingSupplier.get();
            return RETURNTYPE;
        }
        finally {
            this.endWithoutAutoSave();
        }
    }
}

