/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.container;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.dao.IDAO;
import com.helger.dao.container.AbstractDAOContainer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultDAOContainer
extends AbstractDAOContainer {
    private final ICommonsList<IDAO> m_aDAOs;

    public DefaultDAOContainer(IDAO ... iDAOArray) {
        ValueEnforcer.notEmptyNoNullValue(iDAOArray, "DAOs");
        this.m_aDAOs = new CommonsArrayList<IDAO>(iDAOArray);
    }

    public DefaultDAOContainer(@Nonnull @Nonempty Iterable<? extends IDAO> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, "DAOs");
        this.m_aDAOs = new CommonsArrayList<Iterable<? extends IDAO>>(iterable);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDAO> getAllContainedDAOs() {
        return this.m_aRWLock.readLockedGet(this.m_aDAOs::getClone);
    }

    @Override
    public boolean containsAny(@Nullable Predicate<? super IDAO> predicate) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aDAOs.containsAny(predicate));
    }

    public String toString() {
        return new ToStringGenerator(this).append("DAOs", this.m_aDAOs).getToString();
    }
}

