/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.commons.ValueEnforcer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IHasTrashDateTime {
    @Nullable
    public LocalDateTime getTrashDateTime();

    default public boolean hasTrashDateTime() {
        return this.getTrashDateTime() != null;
    }

    @Nullable
    default public LocalDate getTrashDate() {
        LocalDateTime localDateTime = this.getTrashDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    @Nullable
    default public LocalTime getTrashTime() {
        LocalDateTime localDateTime = this.getTrashDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isTrashedAt(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "LocalDateTime");
        return this.hasTrashDateTime() && this.getTrashDateTime().compareTo(localDateTime) <= 0;
    }
}

