/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.config;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.system.SystemProperties;
import com.helger.dns.dnsjava.DnsjavaInit;
import com.helger.dns.ip.IPV4Addr;
import java.net.InetAddress;
import java.security.Security;
import java.time.Duration;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class DNSConfig {
    private static final Duration DEFAULT_RESOLVER_TIMEOUT = Duration.ofSeconds(5L);
    private static final int DEFAULT_RESOLVER_RETRIES = 3;
    private static final ICommonsList<InetAddress> CUSTOM_DEFAULT_DNS_SERVERS = new CommonsArrayList<InetAddress>();
    private static final Logger LOGGER;
    private static final DNSConfig s_aInstance;

    private DNSConfig() {
    }

    public static void setDNSCacheTime(int n) {
        String string = Integer.toString(n);
        try {
            Security.setProperty("networkaddress.cache.ttl", string);
        }
        catch (SecurityException securityException) {
            LOGGER.warn("Failed to set Security property 'networkaddress.cache.ttl' to '" + string + "'");
        }
        try {
            Security.setProperty("networkaddress.cache.negative.ttl", string);
        }
        catch (SecurityException securityException) {
            LOGGER.warn("Failed to set Security property 'networkaddress.cache.negative.ttl' to '" + string + "'");
        }
        SystemProperties.setPropertyValue("disableWSAddressCaching", n == 0);
    }

    @Nonnull
    public static Duration getResolverTimeout() {
        return DEFAULT_RESOLVER_TIMEOUT;
    }

    @Nonnegative
    public static int getResolverRetries() {
        return 3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<InetAddress> getDefaultCustomServers() {
        return (ICommonsList)CUSTOM_DEFAULT_DNS_SERVERS.getClone();
    }

    public static void ensureInited() {
    }

    static {
        CUSTOM_DEFAULT_DNS_SERVERS.add(IPV4Addr.getAsInetAddress(1, 1, 1, 1));
        CUSTOM_DEFAULT_DNS_SERVERS.add(IPV4Addr.getAsInetAddress(1, 0, 0, 1));
        CUSTOM_DEFAULT_DNS_SERVERS.add(IPV4Addr.getAsInetAddress(8, 8, 8, 8));
        CUSTOM_DEFAULT_DNS_SERVERS.add(IPV4Addr.getAsInetAddress(8, 8, 4, 4));
        LOGGER = LoggerFactory.getLogger(DNSConfig.class);
        s_aInstance = new DNSConfig();
        DnsjavaInit.initWithCustomDNSServers(DNSConfig.getDefaultCustomServers());
    }
}

