/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.naptr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.dns.config.DNSConfig;
import com.helger.dns.resolve.ResolverHelper;
import java.net.InetAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

@Immutable
public final class NaptrResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NaptrResolver.class);

    private NaptrResolver() {
    }

    @Nullable
    private static String _getAppliedNAPTRRegEx(@Nonnull String string, @Nonnull String string2) {
        char c = string.charAt(0);
        int n = string.indexOf(c, 1);
        if (n < 0) {
            return null;
        }
        String string3 = string.substring(1, n);
        int n2 = string.indexOf(c, n + 1);
        if (n2 < 0) {
            return null;
        }
        String string4 = string.substring(n + 1, n2);
        String string5 = string.substring(n2 + 1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("NAPTR regex: '" + string3 + "' - '" + string4 + "' - '" + string5 + "'");
        }
        int n3 = "i".equalsIgnoreCase(string5) ? 2 : 0;
        String string6 = RegExHelper.stringReplacePattern(string3, n3, string2, string4);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  NAPTR replacement: '" + string2 + "' -> '" + string6 + "'");
        }
        return string6;
    }

    @Nullable
    public static ICommonsList<NAPTRRecord> lookupNAPTRRecords(@Nullable String string, @Nullable Iterable<? extends InetAddress> iterable) throws TextParseException {
        Record[] recordArray;
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Trying to look up NAPTR on '" + string + "'");
        }
        Lookup lookup2 = new Lookup(string, 35);
        ExtendedResolver extendedResolver = ResolverHelper.createExtendedResolver(iterable);
        extendedResolver.setRetries(1);
        lookup2.setResolver(extendedResolver);
        int n = 1;
        do {
            recordArray = lookup2.run();
        } while (lookup2.getResult() == 2 && --n >= 0);
        if (lookup2.getResult() == 2) {
            extendedResolver.setTCP(true);
            n = 1;
            do {
                recordArray = lookup2.run();
            } while (lookup2.getResult() == 2 && --n >= 0);
        }
        if (lookup2.getResult() != 0) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Error looking up '" + string + "': " + lookup2.getErrorString());
            }
            return null;
        }
        CommonsArrayList<NAPTRRecord> commonsArrayList = new CommonsArrayList<NAPTRRecord>();
        for (Record record : recordArray) {
            commonsArrayList.add((NAPTRRecord)record);
        }
        return commonsArrayList;
    }

    @Nullable
    public static String resolveFromUNAPTR(@Nullable String string, @Nullable Iterable<? extends InetAddress> iterable, @Nonnull @Nonempty String string2) throws TextParseException {
        ValueEnforcer.notEmpty(string2, "ServiceName");
        ICommonsList<NAPTRRecord> iCommonsList = NaptrResolver.lookupNAPTRRecords(string, iterable);
        if (iCommonsList == null) {
            return null;
        }
        return NaptrResolver.resolveUNAPTR(string, iCommonsList, string2);
    }

    @Nullable
    public static String resolveUNAPTR(@Nonnull String string, @Nonnull ICommonsList<NAPTRRecord> iCommonsList, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notNull(string, "DNSName");
        ValueEnforcer.notNull(iCommonsList, "NAPTRRecords");
        ValueEnforcer.notEmpty(string2, "ServiceName");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (NAPTRRecord nAPTRRecord3 : iCommonsList) {
            if (!"U".equalsIgnoreCase(nAPTRRecord3.getFlags()) || !string2.equalsIgnoreCase(nAPTRRecord3.getService())) continue;
            commonsArrayList.add(nAPTRRecord3);
        }
        if (commonsArrayList.isEmpty()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("No matching DNS U-NAPTR records returned for '" + string + "'");
            }
            return null;
        }
        commonsArrayList.sort((nAPTRRecord, nAPTRRecord2) -> {
            int n = nAPTRRecord.getOrder() - nAPTRRecord2.getOrder();
            if (n == 0) {
                n = nAPTRRecord.getPreference() - nAPTRRecord2.getPreference();
            }
            return n;
        });
        for (NAPTRRecord nAPTRRecord3 : commonsArrayList) {
            String string3;
            String string4 = nAPTRRecord3.getRegexp();
            if (StringHelper.getLength(string4) <= 3 || (string3 = NaptrResolver._getAppliedNAPTRRegEx(string4, string)) == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using '" + string3 + "' for original DNS name '" + string + "'");
            }
            return string3;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("None of the matching DNS NAPTR records for '" + string + "' has a valid regular expression. Details: " + commonsArrayList);
        }
        return null;
    }

    static {
        DNSConfig.ensureInited();
    }
}

