/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.css;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.css.ICSSClassProvider;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class DefaultCSSClassProvider
implements ICSSClassProvider,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCSSClassProvider.class);
    private static final ICommonsMap<String, DefaultCSSClassProvider> s_aAll = new CommonsHashMap<String, DefaultCSSClassProvider>();
    private final String m_sCSSClass;
    private transient int m_nHashCode = 0;

    public static void validateCSSClassName(@Nonnull @Nonempty String string) throws IllegalArgumentException {
        ValueEnforcer.notEmpty(string, "CSSClass");
        if (string.indexOf(32) >= 0) {
            throw new IllegalArgumentException("CSS class may not contain spaces '" + string + "'");
        }
        if (!RegExHelper.stringMatchesPattern("-?[_a-zA-Z]+[_a-zA-Z0-9-]*", string)) {
            LOGGER.warn("The CSS class '" + string + "' does not match the naming requirements!");
        }
        if (string.startsWith("_")) {
            throw new IllegalArgumentException("The CSS class name '" + string + "' may rise problems with IE6!");
        }
    }

    private DefaultCSSClassProvider(@Nonnull @Nonempty String string) {
        DefaultCSSClassProvider.validateCSSClassName(string);
        this.m_sCSSClass = string;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getCSSClass() {
        return this.m_sCSSClass;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DefaultCSSClassProvider defaultCSSClassProvider = (DefaultCSSClassProvider)object;
        return this.m_sCSSClass.equals(defaultCSSClassProvider.m_sCSSClass);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_sCSSClass).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("cssClass", this.m_sCSSClass).getToString();
    }

    @Nonnull
    public static DefaultCSSClassProvider create(@Nonnull @Nonempty String string) {
        return s_aAll.computeIfAbsent(string, string2 -> new DefaultCSSClassProvider(string));
    }

    @Nonnull
    public static DefaultCSSClassProvider createUnique() {
        return DefaultCSSClassProvider.create("cssclass" + GlobalIDFactory.getNewIntID());
    }
}

