/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.entity;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.entity.IHTMLEntity;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HTMLEntity
implements IHTMLEntity {
    private final String m_sEntityName;
    private final String m_sEntityReference;

    public HTMLEntity(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        this.m_sEntityName = string;
        this.m_sEntityReference = '&' + string + ';';
    }

    @Override
    @Nonnull
    @Nonempty
    public String getEntityName() {
        return this.m_sEntityName;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getEntityReference() {
        return this.m_sEntityReference;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HTMLEntity hTMLEntity = (HTMLEntity)object;
        return this.m_sEntityName.equals(hTMLEntity.m_sEntityName);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sEntityName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("name", this.m_sEntityName).getToString();
    }
}

