/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCIteratorCallback;
import com.helger.html.hc.IHCIteratorNonBreakableCallback;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeList;
import com.helger.html.hc.IHCTextNode;
import com.helger.html.hc.IHCWrappingNode;
import com.helger.xml.microdom.IMicroElement;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HCHelper {
    private static final char[] ID_REMOVE_CHARS = "[]{}<>-.$/".toCharArray();

    private HCHelper() {
    }

    @Nonnull
    private static EContinue _recursiveIterateTreeBreakable(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        if (iHCNode.hasChildren()) {
            for (IHCNode iHCNode2 : iHCNode.getAllChildren()) {
                if (iHCIteratorCallback.call(iHCNode, iHCNode2).isBreak()) {
                    return EContinue.BREAK;
                }
                if (!HCHelper._recursiveIterateTreeBreakable(iHCNode2, iHCIteratorCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
        }
        return EContinue.CONTINUE;
    }

    @Nonnull
    private static EContinue _recursiveIterateTreeBreakableNoCopy(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        if (iHCNode.hasChildren()) {
            for (IHCNode iHCNode2 : iHCNode.getChildren()) {
                if (iHCIteratorCallback.call(iHCNode, iHCNode2).isBreak()) {
                    return EContinue.BREAK;
                }
                if (!HCHelper._recursiveIterateTreeBreakableNoCopy(iHCNode2, iHCIteratorCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
        }
        return EContinue.CONTINUE;
    }

    public static void iterateTree(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull(iHCNode, "node");
        ValueEnforcer.notNull(iHCIteratorCallback, "callback");
        if (iHCIteratorCallback.call(null, iHCNode).isContinue()) {
            HCHelper._recursiveIterateTreeBreakable(iHCNode, iHCIteratorCallback);
        }
    }

    public static void iterateTreeNoCopy(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull(iHCNode, "node");
        ValueEnforcer.notNull(iHCIteratorCallback, "callback");
        if (iHCIteratorCallback.call(null, iHCNode).isContinue()) {
            HCHelper._recursiveIterateTreeBreakableNoCopy(iHCNode, iHCIteratorCallback);
        }
    }

    public static void iterateChildren(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull(iHCNode, "node");
        ValueEnforcer.notNull(iHCIteratorCallback, "callback");
        HCHelper._recursiveIterateTreeBreakable(iHCNode, iHCIteratorCallback);
    }

    public static void iterateChildrenNoCopy(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorCallback iHCIteratorCallback) {
        ValueEnforcer.notNull(iHCNode, "node");
        ValueEnforcer.notNull(iHCIteratorCallback, "callback");
        HCHelper._recursiveIterateTreeBreakableNoCopy(iHCNode, iHCIteratorCallback);
    }

    private static void _iterateTreeNonBreakable(@Nonnull ICommonsList<IHCNode> iCommonsList, @Nonnull ICommonsList<IHCNode> iCommonsList2, @Nonnull IHCIteratorNonBreakableCallback iHCIteratorNonBreakableCallback) {
        while (iCommonsList.isNotEmpty()) {
            IHCNode iHCNode = (IHCNode)iCommonsList.remove(0);
            IHCNode iHCNode2 = (IHCNode)iCommonsList2.remove(0);
            iHCIteratorNonBreakableCallback.call(iHCNode, iHCNode2);
            if (!iHCNode2.hasChildren()) continue;
            for (IHCNode iHCNode3 : iHCNode2.getChildren()) {
                iCommonsList.add(iHCNode2);
                iCommonsList2.add(iHCNode3);
            }
        }
    }

    public static void iterateTreeNonBreakable(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorNonBreakableCallback iHCIteratorNonBreakableCallback) {
        ValueEnforcer.notNull(iHCNode, "node");
        ValueEnforcer.notNull(iHCIteratorNonBreakableCallback, "callback");
        CommonsArrayList<IHCNode> commonsArrayList = new CommonsArrayList<IHCNode>();
        CommonsArrayList<IHCNode> commonsArrayList2 = new CommonsArrayList<IHCNode>();
        commonsArrayList.add(null);
        commonsArrayList2.add(iHCNode);
        HCHelper._iterateTreeNonBreakable(commonsArrayList, commonsArrayList2, iHCIteratorNonBreakableCallback);
    }

    public static void iterateChildrenNonBreakable(@Nonnull IHCNode iHCNode, @Nonnull IHCIteratorNonBreakableCallback iHCIteratorNonBreakableCallback) {
        ValueEnforcer.notNull(iHCNode, "node");
        ValueEnforcer.notNull(iHCIteratorNonBreakableCallback, "callback");
        CommonsArrayList<IHCNode> commonsArrayList = new CommonsArrayList<IHCNode>();
        CommonsArrayList<IHCNode> commonsArrayList2 = new CommonsArrayList<IHCNode>();
        if (iHCNode.hasChildren()) {
            for (IHCNode iHCNode2 : iHCNode.getChildren()) {
                commonsArrayList.add(iHCNode);
                commonsArrayList2.add(iHCNode2);
            }
        }
        HCHelper._iterateTreeNonBreakable(commonsArrayList, commonsArrayList2, iHCIteratorNonBreakableCallback);
    }

    public static boolean recursiveContainsAtLeastOneTextNode(@Nullable IHCNode iHCNode3) {
        if (iHCNode3 == null) {
            return false;
        }
        if (iHCNode3 instanceof IHCTextNode) {
            return true;
        }
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        HCHelper.iterateChildrenNoCopy(iHCNode3, (iHCNode, iHCNode2) -> {
            if (iHCNode2 instanceof IHCTextNode) {
                mutableBoolean.set(true);
                return EContinue.BREAK;
            }
            return EContinue.CONTINUE;
        });
        return mutableBoolean.booleanValue();
    }

    @Nullable
    public static IMicroElement getFirstChildElement(@Nonnull IMicroElement iMicroElement, @Nonnull EHTMLElement eHTMLElement) {
        ValueEnforcer.notNull(iMicroElement, "element");
        ValueEnforcer.notNull(eHTMLElement, "HTMLElement");
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(eHTMLElement.getElementName());
        if (iMicroElement2 == null) {
            iMicroElement2 = iMicroElement.getFirstChildElement(eHTMLElement.getElementNameUpperCase());
        }
        return iMicroElement2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IMicroElement> getChildElements(@Nonnull IMicroElement iMicroElement, @Nonnull EHTMLElement eHTMLElement) {
        ValueEnforcer.notNull(iMicroElement, "element");
        ValueEnforcer.notNull(eHTMLElement, "HTMLElement");
        CommonsArrayList<IMicroElement> commonsArrayList = new CommonsArrayList<IMicroElement>();
        commonsArrayList.addAll(iMicroElement.getAllChildElements(eHTMLElement.getElementName()));
        commonsArrayList.addAll(iMicroElement.getAllChildElements(eHTMLElement.getElementNameUpperCase()));
        return commonsArrayList;
    }

    private static void _recursiveAddFlattened(@Nullable IHCNode iHCNode2, @Nonnull List<IHCNode> list) {
        ValueEnforcer.notNull(list, "RealList");
        if (iHCNode2 != null) {
            if (iHCNode2 instanceof IHCNodeList) {
                IHCNodeList iHCNodeList = (IHCNodeList)iHCNode2;
                iHCNodeList.forAllChildren(iHCNode -> HCHelper._recursiveAddFlattened(iHCNode, list));
            } else {
                list.add(iHCNode2);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCNode> getAsFlattenedList(@Nullable IHCNode iHCNode) {
        CommonsArrayList<IHCNode> commonsArrayList = new CommonsArrayList<IHCNode>();
        HCHelper._recursiveAddFlattened(iHCNode, commonsArrayList);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCNode> getAsFlattenedList(@Nullable Iterable<? extends IHCNode> iterable) {
        CommonsArrayList<IHCNode> commonsArrayList = new CommonsArrayList<IHCNode>();
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                HCHelper._recursiveAddFlattened(iHCNode, commonsArrayList);
            }
        }
        return commonsArrayList;
    }

    @Nullable
    public static IHCNode getUnwrappedNode(@Nullable IHCNode iHCNode) {
        if (HCHelper.isWrappedNode(iHCNode)) {
            return HCHelper.getUnwrappedNode(((IHCWrappingNode)iHCNode).getWrappedNode());
        }
        return iHCNode;
    }

    public static boolean isWrappedNode(@Nullable IHCNode iHCNode) {
        return iHCNode instanceof IHCWrappingNode;
    }

    @Nonnull
    public static String getAsHTMLID(@Nullable String string) {
        String string2 = StringHelper.getNotNull(string, "").trim();
        return (string2 = StringHelper.removeMultiple(string2, ID_REMOVE_CHARS)).isEmpty() ? "_" : string2;
    }
}

