/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.config;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.commons.url.URLParameterDecoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class HCConsistencyChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HCConsistencyChecker.class);
    private static final int MAX_CSS_IE = 31;
    private static final HCConsistencyChecker s_aInstance = new HCConsistencyChecker();

    private HCConsistencyChecker() {
    }

    public static void consistencyError(@Nonnull String string) {
        if (GlobalDebug.isDebugMode()) {
            throw new IllegalStateException("HC Consistency check error: " + string);
        }
        LOGGER.error("HC Consistency check error: " + string);
    }

    public static void checkIfStringURLIsEscaped(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            URLParameterDecoder uRLParameterDecoder;
            String string2;
            if (string.contains("&amp;")) {
                HCConsistencyChecker.consistencyError("The URL '" + string + "' seems to be already XML escaped - please use an unescaped URL!!");
            }
            if (!string.equals(string2 = (uRLParameterDecoder = new URLParameterDecoder(URLHelper.CHARSET_URL_OBJ)).getDecoded(string))) {
                HCConsistencyChecker.consistencyError("The URL '" + string + "' seems to be already URL encoded - please use a decoded URL!!");
            }
        }
    }

    public static void checkForMaximumCSSResources(int n) {
        if (n > 31) {
            HCConsistencyChecker.consistencyError("You are including more than 31 CSS files (" + n + ") in your request, which will be ignored by Internet Explorer (at least up to version 8)!");
        }
    }
}

