/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.system.ENewLineMode;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.config.DefaultHCOnDocumentReadyProvider;
import com.helger.html.hc.config.EHCScriptInlineMode;
import com.helger.html.hc.config.EHCStyleInlineMode;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.config.IHCOnDocumentReadyProvider;
import com.helger.html.hc.config.IHCSettingsProviderSPI;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HCSettings {
    public static final EHTMLVersion DEFAULT_HTML_VERSION = EHTMLVersion.HTML5;
    public static final boolean DEFAULT_AUTO_COMPLETE_OFF_FOR_PASSWORD_EDITS = !GlobalDebug.isDebugMode();
    public static final EHCScriptInlineMode DEFAULT_SCRIPT_INLINE_MODE = EHCScriptInlineMode.PLAIN_TEXT_WRAPPED_IN_COMMENT;
    public static final EHCStyleInlineMode DEFAULT_STYLE_MODE = EHCStyleInlineMode.PLAIN_TEXT_NO_ESCAPE;
    private static final Logger LOGGER = LoggerFactory.getLogger(HCSettings.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static HCConversionSettings s_aConversionSettings = new HCConversionSettings(DEFAULT_HTML_VERSION);
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bAutoCompleteOffForPasswordEdits = DEFAULT_AUTO_COMPLETE_OFF_FOR_PASSWORD_EDITS;
    @GuardedBy(value="s_aRWLock")
    private static int s_nTextAreaDefaultRows = -1;
    @GuardedBy(value="s_aRWLock")
    private static IHCOnDocumentReadyProvider s_aOnDocumentReadyProvider = new DefaultHCOnDocumentReadyProvider();
    @GuardedBy(value="s_aRWLock")
    private static EHCScriptInlineMode s_eScriptInlineMode = DEFAULT_SCRIPT_INLINE_MODE;
    @GuardedBy(value="s_aRWLock")
    private static EHCStyleInlineMode s_eStyleInlineMode = DEFAULT_STYLE_MODE;
    @GuardedBy(value="s_aRWLock")
    private static ENewLineMode s_eNewLineMode = ENewLineMode.DEFAULT;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bOOBDebugging = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bScriptsInBody = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bUseRegularResources = GlobalDebug.isDebugMode();
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);

    private HCSettings() {
    }

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    public static void setConversionSettings(@Nonnull HCConversionSettings hCConversionSettings) {
        ValueEnforcer.notNull(hCConversionSettings, "ConversionSettings");
        s_aRWLock.writeLockedGet(() -> {
            s_aConversionSettings = hCConversionSettings;
            return s_aConversionSettings;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static HCConversionSettings getMutableConversionSettings() {
        return s_aRWLock.readLockedGet(() -> s_aConversionSettings);
    }

    @Nonnull
    public static IHCConversionSettings getConversionSettings() {
        return HCSettings.getMutableConversionSettings();
    }

    @Nonnull
    public static HCConversionSettings getConversionSettingsWithoutNamespaces() {
        HCConversionSettings hCConversionSettings = HCSettings.getMutableConversionSettings().getClone();
        hCConversionSettings.getXMLWriterSettings().setEmitNamespaces(false);
        return hCConversionSettings;
    }

    @Nonnull
    public static Charset getHTMLCharset() {
        return HCSettings.getConversionSettings().getXMLWriterSettings().getCharset();
    }

    public static void setDefaultHTMLVersion(@Nonnull EHTMLVersion eHTMLVersion) {
        ValueEnforcer.notNull(eHTMLVersion, "HTMLVersion");
        EHTMLVersion eHTMLVersion2 = HCSettings.getMutableConversionSettings().getHTMLVersion();
        HCSettings.getMutableConversionSettings().setHTMLVersion(eHTMLVersion);
        HCSettings.getMutableConversionSettings().setXMLWriterSettings(HCConversionSettings.createDefaultXMLWriterSettings(eHTMLVersion));
        if (!eHTMLVersion.equals((Object)eHTMLVersion2) && !HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default HTML version changed from " + (Object)((Object)eHTMLVersion2) + " to " + (Object)((Object)eHTMLVersion));
        }
        if (eHTMLVersion.isAtLeastHTML5()) {
            if (HCSettings.getScriptInlineMode() != EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE) {
                HCSettings.setScriptInlineMode(EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE);
            }
        } else if (HCSettings.getScriptInlineMode() != DEFAULT_SCRIPT_INLINE_MODE) {
            HCSettings.setScriptInlineMode(DEFAULT_SCRIPT_INLINE_MODE);
        }
    }

    public static boolean isAutoCompleteOffForPasswordEdits() {
        return s_aRWLock.readLockedBoolean(() -> s_bAutoCompleteOffForPasswordEdits);
    }

    public static void setAutoCompleteOffForPasswordEdits(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bAutoCompleteOffForPasswordEdits = bl;
            return s_bAutoCompleteOffForPasswordEdits;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default @autocomplete for <input type=password> set to " + (bl ? "off" : "on"));
        }
    }

    public static int getTextAreaDefaultRows() {
        return s_aRWLock.readLockedInt(() -> s_nTextAreaDefaultRows);
    }

    public static void setTextAreaDefaultRows(int n) {
        s_aRWLock.writeLockedInt(() -> {
            s_nTextAreaDefaultRows = n;
            return s_nTextAreaDefaultRows;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default <textarea> rows set to " + n);
        }
    }

    @Nonnull
    public static IHCOnDocumentReadyProvider getOnDocumentReadyProvider() {
        return s_aRWLock.readLockedGet(() -> s_aOnDocumentReadyProvider);
    }

    public static void setOnDocumentReadyProvider(@Nonnull IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider) {
        ValueEnforcer.notNull(iHCOnDocumentReadyProvider, "OnDocumentReadyProvider");
        s_aRWLock.writeLockedGet(() -> {
            s_aOnDocumentReadyProvider = iHCOnDocumentReadyProvider;
            return s_aOnDocumentReadyProvider;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default JS onDocumentReady provider set to " + iHCOnDocumentReadyProvider);
        }
    }

    @Nonnull
    public static EHCScriptInlineMode getScriptInlineMode() {
        return s_aRWLock.readLockedGet(() -> s_eScriptInlineMode);
    }

    public static void setScriptInlineMode(@Nonnull EHCScriptInlineMode eHCScriptInlineMode) {
        ValueEnforcer.notNull(eHCScriptInlineMode, "Mode");
        EHCScriptInlineMode eHCScriptInlineMode2 = HCSettings.getScriptInlineMode();
        s_aRWLock.writeLockedGet(() -> {
            s_eScriptInlineMode = eHCScriptInlineMode;
            return s_eScriptInlineMode;
        });
        if (!eHCScriptInlineMode.equals((Object)eHCScriptInlineMode2) && !HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default <script> mode changed from " + (Object)((Object)eHCScriptInlineMode2) + " to " + (Object)((Object)eHCScriptInlineMode));
        }
    }

    @Nonnull
    public static EHCStyleInlineMode getStyleInlineMode() {
        return s_aRWLock.readLockedGet(() -> s_eStyleInlineMode);
    }

    public static void setStyleInlineMode(@Nonnull EHCStyleInlineMode eHCStyleInlineMode) {
        ValueEnforcer.notNull(eHCStyleInlineMode, "mode");
        EHCStyleInlineMode eHCStyleInlineMode2 = HCSettings.getStyleInlineMode();
        s_aRWLock.writeLockedGet(() -> {
            s_eStyleInlineMode = eHCStyleInlineMode;
            return s_eStyleInlineMode;
        });
        if (!eHCStyleInlineMode.equals((Object)eHCStyleInlineMode2) && !HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default <style> mode changed from " + (Object)((Object)eHCStyleInlineMode2) + " to " + (Object)((Object)eHCStyleInlineMode));
        }
    }

    @Nonnull
    public static ENewLineMode getNewLineMode() {
        return s_aRWLock.readLockedGet(() -> s_eNewLineMode);
    }

    public static void setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        ValueEnforcer.notNull(eNewLineMode, "NewLineMode");
        ENewLineMode eNewLineMode2 = HCSettings.getNewLineMode();
        s_aRWLock.writeLockedGet(() -> {
            s_eNewLineMode = eNewLineMode;
            return s_eNewLineMode;
        });
        if (!eNewLineMode.equals((Object)eNewLineMode2) && !HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default new line mode changed from " + (Object)((Object)eNewLineMode2) + " to " + (Object)((Object)eNewLineMode));
        }
    }

    public static boolean isOutOfBandDebuggingEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bOOBDebugging);
    }

    public static void setOutOfBandDebuggingEnabled(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bOOBDebugging = bl;
            return s_bOOBDebugging;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default out-of-band debugging " + (bl ? "enabled" : "disabled"));
        }
    }

    public static boolean isScriptsInBody() {
        return s_aRWLock.readLockedBoolean(() -> s_bScriptsInBody);
    }

    public static void setScriptsInBody(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bScriptsInBody = bl;
            return s_bScriptsInBody;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default put <scripts>s in " + (bl ? "<body>" : "<head>"));
        }
    }

    public static boolean isUseRegularResources() {
        return s_aRWLock.readLockedBoolean(() -> s_bUseRegularResources);
    }

    public static void setUseRegularResources(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bUseRegularResources = bl;
            return s_bUseRegularResources;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Default using " + (bl ? "regular" : "minified") + " resources");
        }
    }

    static {
        for (IHCSettingsProviderSPI iHCSettingsProviderSPI : ServiceLoaderHelper.getAllSPIImplementations(IHCSettingsProviderSPI.class)) {
            iHCSettingsProviderSPI.initHCSettings();
        }
    }
}

