/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.ext;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.EURLProtocol;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.html.textlevel.AbstractHCA;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCA_MailTo
extends AbstractHCA<HCA_MailTo> {
    private final String m_sEmailAddress;

    public HCA_MailTo(@Nonnull String string) {
        super(new SimpleURL(EURLProtocol.MAILTO.getProtocol() + string));
        this.m_sEmailAddress = ValueEnforcer.notNull(string, "Email");
    }

    @Nonnull
    public String getEmail() {
        return this.m_sEmailAddress;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("email", this.m_sEmailAddress).getToString();
    }

    @Nullable
    public static HCA_MailTo createLinkedEmail(@Nullable String string) {
        return HCA_MailTo.createLinkedEmail(string, string);
    }

    @Nullable
    public static HCA_MailTo createLinkedEmail(@Nullable IEmailAddress iEmailAddress) {
        return iEmailAddress == null ? null : HCA_MailTo.createLinkedEmail(iEmailAddress.getAddress(), iEmailAddress.getDisplayName());
    }

    @Nullable
    public static HCA_MailTo createLinkedEmail(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        HCA_MailTo hCA_MailTo = new HCA_MailTo(string);
        hCA_MailTo.addChild(StringHelper.getNotEmpty(string2, string));
        return hCA_MailTo;
    }
}

