/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.ext;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCConditionalCommentNode;
import com.helger.html.hc.impl.AbstractHCWrappingNode;
import com.helger.html.hc.impl.HCCommentNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HCConditionalCommentNode
extends AbstractHCWrappingNode
implements IHCConditionalCommentNode {
    public static final Version IE5 = new Version(5);
    public static final Version IE6 = new Version(6);
    public static final Version IE7 = new Version(7);
    public static final Version IE8 = new Version(8);
    public static final Version IE9 = new Version(9);
    public static final Version IE10 = new Version(10);
    public static final Version IE11 = new Version(11);
    public static final String CONDITION_IF_IE_GENERIC = "if IE";
    public static final String CONDITION_IF_IE = "if IE ";
    public static final String CONDITION_IF_NOT_IE = "if !IE ";
    public static final String CONDITION_IF_LT_IE = "if lt IE ";
    public static final String CONDITION_IF_LTE_IE = "if lte IE ";
    public static final String CONDITION_IF_GT_IE = "if gt IE ";
    public static final String CONDITION_IF_GTE_IE = "if gte IE ";
    private final String m_sCondition;
    private final IHCNode m_aWrappedNode;

    public HCConditionalCommentNode(@Nonnull @Nonempty String string, @Nonnull IHCNode iHCNode) {
        this.m_sCondition = ValueEnforcer.notEmpty(string, "Condition");
        ValueEnforcer.notNull(iHCNode, "WrappedNode");
        ValueEnforcer.isFalse(iHCNode instanceof HCCommentNode, "You cannot wrap a comment inside a conditional comment");
        ValueEnforcer.isFalse(iHCNode instanceof HCConditionalCommentNode, "You cannot wrap a conditional comment inside another conditional comment");
        this.m_aWrappedNode = iHCNode;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getCondition() {
        return this.m_sCondition;
    }

    @Override
    @Nonnull
    public IHCNode getWrappedNode() {
        return this.m_aWrappedNode;
    }

    @Override
    @Nullable
    protected IMicroNode internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        IMicroNode iMicroNode = super.internalConvertToMicroNode(iHCConversionSettingsToNode);
        if (iMicroNode == null) {
            return null;
        }
        IXMLWriterSettings iXMLWriterSettings = iHCConversionSettingsToNode.getXMLWriterSettings();
        String string = iXMLWriterSettings.getIndent().isAlign() ? iXMLWriterSettings.getNewLineString() : "";
        HCCommentNode hCCommentNode = new HCCommentNode('[' + this.m_sCondition + "]>" + string + MicroWriter.getNodeAsString(iMicroNode, iXMLWriterSettings) + "<![endif]");
        return HCRenderer.getAsNode(hCCommentNode, iHCConversionSettingsToNode);
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("condition", this.m_sCondition).append("wrappedNode", this.m_aWrappedNode).getToString();
    }

    @Nonnull
    public static HCConditionalCommentNode createForIE(@Nonnull IHCNode iHCNode) {
        return new HCConditionalCommentNode(CONDITION_IF_IE_GENERIC, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion(@Nonnull Version version, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(version, "Version");
        return new HCConditionalCommentNode(CONDITION_IF_IE + version.getAsString(), iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion5(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEExactVersion(IE5, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion6(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEExactVersion(IE6, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion7(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEExactVersion(IE7, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion8(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEExactVersion(IE8, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion9(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEExactVersion(IE9, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion10(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEExactVersion(IE10, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEExactVersion11(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEExactVersion(IE11, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIENotVersion(@Nonnull Version version, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(version, "Version");
        return new HCConditionalCommentNode(CONDITION_IF_NOT_IE + version.getAsString(), iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion(@Nonnull Version version, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(version, "Version");
        return new HCConditionalCommentNode(CONDITION_IF_LT_IE + version.getAsString(), iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion5(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerThanVersion(IE5, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion6(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerThanVersion(IE6, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion7(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerThanVersion(IE7, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion8(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerThanVersion(IE8, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion9(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerThanVersion(IE9, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion10(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerThanVersion(IE10, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerThanVersion11(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerThanVersion(IE11, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion(@Nonnull Version version, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(version, "Version");
        return new HCConditionalCommentNode(CONDITION_IF_LTE_IE + version.getAsString(), iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion5(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerOrEqualThanVersion(IE5, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion6(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerOrEqualThanVersion(IE6, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion7(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerOrEqualThanVersion(IE7, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion8(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerOrEqualThanVersion(IE8, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion9(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerOrEqualThanVersion(IE9, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion10(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerOrEqualThanVersion(IE10, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIELowerOrEqualThanVersion11(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIELowerOrEqualThanVersion(IE11, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion(@Nonnull Version version, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(version, "Version");
        return new HCConditionalCommentNode(CONDITION_IF_GT_IE + version.getAsString(), iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion5(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterThanVersion(IE5, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion6(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterThanVersion(IE6, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion7(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterThanVersion(IE7, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion8(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterThanVersion(IE8, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion9(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterThanVersion(IE9, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion10(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterThanVersion(IE10, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterThanVersion11(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterThanVersion(IE11, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion(@Nonnull Version version, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(version, "Version");
        return new HCConditionalCommentNode(CONDITION_IF_GTE_IE + version.getAsString(), iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion5(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterOrEqualThanVersion(IE5, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion6(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterOrEqualThanVersion(IE6, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion7(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterOrEqualThanVersion(IE7, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion8(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterOrEqualThanVersion(IE8, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion9(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterOrEqualThanVersion(IE9, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion10(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterOrEqualThanVersion(IE10, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode createForIEGreaterOrEqualThanVersion11(@Nonnull IHCNode iHCNode) {
        return HCConditionalCommentNode.createForIEGreaterOrEqualThanVersion(IE11, iHCNode);
    }

    @Nullable
    public static HCConditionalCommentNode getFromStringOrNull(@Nullable String string, @Nonnull IHCNode iHCNode) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return HCConditionalCommentNode.getAsConditionalCommentNode(string, iHCNode);
    }

    @Nonnull
    public static HCConditionalCommentNode getAsConditionalCommentNode(@Nonnull @Nonempty String string, @Nonnull IHCNode iHCNode) {
        if (iHCNode instanceof HCConditionalCommentNode) {
            return (HCConditionalCommentNode)iHCNode;
        }
        return new HCConditionalCommentNode(string, iHCNode);
    }
}

