/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.collection.attr.AttributeContainer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.propertyvalue.ICSSValue;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.EHTMLRole;
import com.helger.html.EHTMLVersion;
import com.helger.html.annotation.DeprecatedInHTML5;
import com.helger.html.annotation.SinceHTML5;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.EHCContentEditable;
import com.helger.html.hc.html.EHCDraggable;
import com.helger.html.hc.html.EHCDropZone;
import com.helger.html.hc.html.EHCTextDirection;
import com.helger.html.hc.html.FakeJS;
import com.helger.html.hc.html.IHCAttrContainer;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.impl.AbstractHCNode;
import com.helger.html.js.CJS;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.js.EJSEvent;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSEventMap;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import java.util.Map;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractHCElement<IMPLTYPE extends AbstractHCElement<IMPLTYPE>>
extends AbstractHCNode
implements IHCElement<IMPLTYPE> {
    public static final ETriState DEFAULT_TRANSLATE = ETriState.UNDEFINED;
    public static final boolean DEFAULT_UNFOCUSABLE = false;
    public static final boolean DEFAULT_HIDDEN = false;
    public static final boolean DEFAULT_SPELLCHECK = false;
    private final EHTMLElement m_eElement;
    private final String m_sElementName;
    private String m_sID;
    private String m_sTitle;
    private String m_sLanguage;
    private EHCTextDirection m_eDirection;
    private ICommonsOrderedSet<ICSSClassProvider> m_aCSSClassProviders;
    private ICommonsOrderedMap<ECSSProperty, ICSSValue> m_aStyles;
    private JSEventMap m_aJSHandler;
    private boolean m_bUnfocusable = false;
    private long m_nTabIndex = -5L;
    private String m_sAccessKey;
    private ETriState m_eTranslate = DEFAULT_TRANSLATE;
    private EHCContentEditable m_eContentEditable;
    private String m_sContextMenuID;
    private EHCDraggable m_eDraggable;
    private EHCDropZone m_eDropZone;
    private boolean m_bHidden = false;
    private boolean m_bSpellCheck = false;
    private EHTMLRole m_eRole;
    private final HCAttrCont m_aCustomAttrs = new HCAttrCont();
    private static final AnnotationUsageCache s_aAUC_D_HTML5 = new AnnotationUsageCache(DeprecatedInHTML5.class);
    private static final AnnotationUsageCache s_aAUC_S_HTML5 = new AnnotationUsageCache(SinceHTML5.class);

    protected AbstractHCElement(@Nonnull EHTMLElement eHTMLElement) {
        this.m_eElement = ValueEnforcer.notNull(eHTMLElement, "Element");
        this.m_sElementName = eHTMLElement.getElementName();
    }

    @Override
    @Nonnull
    public final EHTMLElement getElement() {
        return this.m_eElement;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getTagName() {
        return this.m_sElementName;
    }

    @Override
    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setID(@Nullable String string) {
        return this.setID(string, false);
    }

    public static boolean isValidID(@Nullable String string) {
        return !StringHelper.hasText(string) || !RegExHelper.stringMatchesPattern(".*\\s.*", string);
    }

    @Nonnull
    public final IMPLTYPE setID(@Nullable String string, boolean bl) {
        if (!AbstractHCElement.isValidID(string)) {
            HCConsistencyChecker.consistencyError("HC object ID '" + string + "' is invalid!");
        } else {
            if (!bl && this.m_sID != null) {
                if (StringHelper.hasText(string)) {
                    if (!this.m_sID.equals(string)) {
                        HCConsistencyChecker.consistencyError("Overwriting HC object ID '" + this.m_sID + "' with '" + string + "' - this may have side effects!");
                    }
                } else {
                    HCConsistencyChecker.consistencyError("The HC object ID '" + this.m_sID + "' will be removed - this may have side effects");
                }
            }
            this.m_sID = string;
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getTitle() {
        return this.m_sTitle;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTitle(@Nullable String string) {
        this.m_sTitle = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean containsClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        return this.m_aCSSClassProviders != null && iCSSClassProvider != null && this.m_aCSSClassProviders.contains(iCSSClassProvider);
    }

    @Override
    @Nonnull
    public final IMPLTYPE addClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        if (iCSSClassProvider != null) {
            if (this.m_aCSSClassProviders == null) {
                this.m_aCSSClassProviders = new CommonsLinkedHashSet<ICSSClassProvider>();
            }
            this.m_aCSSClassProviders.add(iCSSClassProvider);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        if (this.m_aCSSClassProviders != null && iCSSClassProvider != null) {
            this.m_aCSSClassProviders.remove(iCSSClassProvider);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllClasses() {
        if (this.m_aCSSClassProviders != null) {
            this.m_aCSSClassProviders.clear();
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedSet<ICSSClassProvider> getAllClasses() {
        return new CommonsLinkedHashSet<ICommonsOrderedSet<ICSSClassProvider>>(this.m_aCSSClassProviders);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedSet<String> getAllClassNames() {
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        if (this.m_aCSSClassProviders != null) {
            for (ICSSClassProvider iCSSClassProvider : this.m_aCSSClassProviders) {
                String string = iCSSClassProvider.getCSSClass();
                if (!StringHelper.hasText(string)) continue;
                commonsLinkedHashSet.add(string);
            }
        }
        return commonsLinkedHashSet;
    }

    @Override
    public final boolean hasAnyClass() {
        return this.m_aCSSClassProviders != null && this.m_aCSSClassProviders.isNotEmpty();
    }

    @Override
    @Nullable
    public final String getAllClassesAsString() {
        if (this.m_aCSSClassProviders == null) {
            return null;
        }
        int n = this.m_aCSSClassProviders.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.m_aCSSClassProviders.getFirst().getCSSClass();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSClassProvider iCSSClassProvider : this.m_aCSSClassProviders) {
            String string = iCSSClassProvider.getCSSClass();
            if (!StringHelper.hasText(string)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<ECSSProperty, ICSSValue> getAllStyles() {
        return new CommonsLinkedHashMap<ECSSProperty, ICSSValue>((Map<ECSSProperty, ICSSValue>)this.m_aStyles);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ICSSValue> getAllStyleValues() {
        return this.m_aStyles == null ? new CommonsArrayList() : this.m_aStyles.copyOfValues();
    }

    @Override
    @Nullable
    public final ICSSValue getStyleValue(@Nullable ECSSProperty eCSSProperty) {
        return eCSSProperty == null || this.m_aStyles == null ? null : (ICSSValue)this.m_aStyles.get(eCSSProperty);
    }

    @Override
    public final boolean containsStyle(@Nullable ECSSProperty eCSSProperty) {
        return this.m_aStyles != null && this.m_aStyles.containsKey(eCSSProperty);
    }

    @Override
    public final boolean hasStyle(@Nullable ICSSValue iCSSValue) {
        if (iCSSValue == null || this.m_aStyles == null) {
            return false;
        }
        ECSSProperty eCSSProperty = iCSSValue.getProp();
        return EqualsHelper.equals(this.m_aStyles.get(eCSSProperty), iCSSValue);
    }

    @Override
    public final boolean hasAnyStyle() {
        return this.m_aStyles != null && this.m_aStyles.isNotEmpty();
    }

    @Override
    @Nonnull
    public final IMPLTYPE addStyle(@Nullable ICSSValue iCSSValue) {
        if (iCSSValue != null) {
            if (this.m_aStyles == null) {
                this.m_aStyles = new CommonsLinkedHashMap<ECSSProperty, ICSSValue>();
            }
            this.m_aStyles.put(iCSSValue.getProp(), iCSSValue);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeStyle(@Nonnull ECSSProperty eCSSProperty) {
        if (this.m_aStyles != null) {
            this.m_aStyles.remove(eCSSProperty);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllStyles() {
        this.m_aStyles.clear();
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getAllStylesAsString(@Nonnull ICSSWriterSettings iCSSWriterSettings) {
        if (this.m_aStyles == null || this.m_aStyles.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSValue iCSSValue : this.m_aStyles.values()) {
            stringBuilder.append(iCSSValue.getAsCSSString(iCSSWriterSettings));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public final EHCTextDirection getDirection() {
        return this.m_eDirection;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDirection(@Nullable EHCTextDirection eHCTextDirection) {
        this.m_eDirection = eHCTextDirection;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getLanguage() {
        return this.m_sLanguage;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setLanguage(@Nullable String string) {
        this.m_sLanguage = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    @ReturnsMutableObject
    public final JSEventMap getEventMap() {
        return this.m_aJSHandler;
    }

    @Override
    @Nullable
    public final IHasJSCode getEventHandler(@Nullable EJSEvent eJSEvent) {
        return this.m_aJSHandler == null ? null : this.m_aJSHandler.getHandler(eJSEvent);
    }

    @Override
    public final boolean containsEventHandler(@Nullable EJSEvent eJSEvent) {
        return this.m_aJSHandler != null && this.m_aJSHandler.containsHandler(eJSEvent);
    }

    @Override
    @Nonnull
    public final IMPLTYPE addEventHandler(@Nonnull EJSEvent eJSEvent, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (this.m_aJSHandler == null) {
                this.m_aJSHandler = new JSEventMap();
            }
            this.m_aJSHandler.addHandler(eJSEvent, iHasJSCode);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE prependEventHandler(@Nonnull EJSEvent eJSEvent, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (this.m_aJSHandler == null) {
                this.m_aJSHandler = new JSEventMap();
            }
            this.m_aJSHandler.prependHandler(eJSEvent, iHasJSCode);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setEventHandler(@Nonnull EJSEvent eJSEvent, @Nullable IHasJSCode iHasJSCode) {
        if (iHasJSCode != null) {
            if (this.m_aJSHandler == null) {
                this.m_aJSHandler = new JSEventMap();
            }
            this.m_aJSHandler.setHandler(eJSEvent, iHasJSCode);
        } else if (this.m_aJSHandler != null) {
            this.m_aJSHandler.removeHandler(eJSEvent);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllEventHandler(@Nullable EJSEvent eJSEvent) {
        if (this.m_aJSHandler != null) {
            this.m_aJSHandler.removeHandler(eJSEvent);
        }
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isUnfocusable() {
        return this.m_bUnfocusable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setUnfocusable(boolean bl) {
        this.m_bUnfocusable = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isHidden() {
        return this.m_bHidden;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHidden(boolean bl) {
        this.m_bHidden = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @CheckForSigned
    public final long getTabIndex() {
        return this.m_nTabIndex;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTabIndex(long l) {
        this.m_nTabIndex = l;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getAccessKey() {
        return this.m_sAccessKey;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAccessKey(@Nullable String string) {
        this.m_sAccessKey = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isTranslateOn() {
        return this.m_eTranslate.isTrue();
    }

    @Override
    public final boolean isTranslateOff() {
        return this.m_eTranslate.isFalse();
    }

    @Override
    public final boolean isTranslateUndefined() {
        return this.m_eTranslate.isUndefined();
    }

    @Override
    @Nonnull
    public final ETriState getTranslate() {
        return this.m_eTranslate;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTranslate(@Nonnull ETriState eTriState) {
        this.m_eTranslate = ValueEnforcer.notNull(eTriState, "Translate");
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCContentEditable getContentEditable() {
        return this.m_eContentEditable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setContentEditable(@Nullable EHCContentEditable eHCContentEditable) {
        this.m_eContentEditable = eHCContentEditable;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getContextMenu() {
        return this.m_sContextMenuID;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setContextMenu(@Nullable String string) {
        this.m_sContextMenuID = string;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCDraggable getDraggable() {
        return this.m_eDraggable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDraggable(@Nullable EHCDraggable eHCDraggable) {
        this.m_eDraggable = eHCDraggable;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCDropZone getDropZone() {
        return this.m_eDropZone;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDropZone(@Nullable EHCDropZone eHCDropZone) {
        this.m_eDropZone = eHCDropZone;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    public final boolean isSpellCheck() {
        return this.m_bSpellCheck;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSpellCheck(boolean bl) {
        this.m_bSpellCheck = bl;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHTMLRole getRole() {
        return this.m_eRole;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setRole(@Nullable EHTMLRole eHTMLRole) {
        this.m_eRole = eHTMLRole;
        return (IMPLTYPE)((AbstractHCElement)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final IHCAttrContainer customAttrs() {
        return this.m_aCustomAttrs;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        if (this.m_bUnfocusable) {
            this.addEventHandler(EJSEvent.FOCUS, FakeJS.JS_BLUR);
        }
    }

    private static void _checkDeprecation(Class<?> clazz, String string, EHTMLVersion eHTMLVersion) {
        if (eHTMLVersion.isAtLeastHTML5()) {
            if (s_aAUC_D_HTML5.hasAnnotation(clazz)) {
                HCConsistencyChecker.consistencyError("The element '" + string + "' is deprecated in HTML5");
            }
        } else if (s_aAUC_S_HTML5.hasAnnotation(clazz)) {
            HCConsistencyChecker.consistencyError("The element '" + string + "' is only available in HTML5");
        }
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        EHTMLVersion eHTMLVersion = iHCConversionSettingsToNode.getHTMLVersion();
        AbstractHCElement._checkDeprecation(this.getClass(), this.getTagName(), eHTMLVersion);
        if (eHTMLVersion.isAtLeastHTML5() && this.m_aCustomAttrs != null) {
            for (Map.Entry entry : this.m_aCustomAttrs.entrySet()) {
                String string = ((IMicroQName)entry.getKey()).getName();
                if (StringHelper.startsWith(string, "data-") || StringHelper.startsWith(string, "aria-") || this.m_eElement == EHTMLElement.LINK) continue;
                HCConsistencyChecker.consistencyError("Custom HTML5 attribute '" + string + "' does not start with one of the proposed prefixes '" + "data-" + "' or '" + "aria-" + "'");
            }
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IMicroElement createMicroElement(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return new MicroElement(iHCConversionSettingsToNode.getHTMLNamespaceURI(), this.m_sElementName);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void fillMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        boolean bl = iHCConversionSettingsToNode.getHTMLVersion().isAtLeastHTML5();
        if (StringHelper.hasText(this.m_sID)) {
            iMicroElement.setAttribute(CHTMLAttributes.ID, this.m_sID);
        }
        if (StringHelper.hasText(this.m_sTitle)) {
            iMicroElement.setAttribute(CHTMLAttributes.TITLE, this.m_sTitle);
        }
        if (StringHelper.hasText(this.m_sLanguage)) {
            iMicroElement.setAttribute((IMicroQName)new MicroQName("http://www.w3.org/XML/1998/namespace", CHTMLAttributes.LANG.getName()), this.m_sLanguage);
            iMicroElement.setAttribute(CHTMLAttributes.LANG, this.m_sLanguage);
        }
        if (this.m_eDirection != null) {
            iMicroElement.setAttribute(CHTMLAttributes.DIR, (IHasAttributeValue)this.m_eDirection);
        }
        iMicroElement.setAttribute(CHTMLAttributes.CLASS, this.getAllClassesAsString());
        iMicroElement.setAttribute(CHTMLAttributes.STYLE, this.getAllStylesAsString(iHCConversionSettingsToNode.getCSSWriterSettings()));
        if (this.m_aJSHandler != null) {
            IJSWriterSettings iJSWriterSettings = iHCConversionSettingsToNode.getJSWriterSettings();
            for (EJSEvent eJSEvent : EJSEvent.values()) {
                CollectingJSCodeProvider collectingJSCodeProvider = this.m_aJSHandler.getHandler(eJSEvent);
                if (collectingJSCodeProvider == null) continue;
                String string = collectingJSCodeProvider.getJSCode(iJSWriterSettings);
                iMicroElement.setAttribute(eJSEvent.getHTMLEventName(), CJS.JS_PREFIX + string);
            }
        }
        if (this.m_nTabIndex != -5L) {
            iMicroElement.setAttribute(CHTMLAttributes.TABINDEX, this.m_nTabIndex);
        }
        if (StringHelper.hasText(this.m_sAccessKey)) {
            iMicroElement.setAttribute(CHTMLAttributes.ACCESSKEY, this.m_sAccessKey);
        }
        if (bl) {
            if (this.m_eTranslate.isDefined()) {
                iMicroElement.setAttribute(CHTMLAttributes.TRANSLATE, this.m_eTranslate.isTrue() ? "yes" : "no");
            }
            if (this.m_eContentEditable != null) {
                iMicroElement.setAttribute(CHTMLAttributes.CONTENTEDITABLE, (IHasAttributeValue)this.m_eContentEditable);
            }
            if (StringHelper.hasText(this.m_sContextMenuID)) {
                iMicroElement.setAttribute(CHTMLAttributes.CONTEXTMENU, this.m_sContextMenuID);
            }
            if (this.m_eDraggable != null) {
                iMicroElement.setAttribute(CHTMLAttributes.DRAGGABLE, (IHasAttributeValue)this.m_eDraggable);
            }
            if (this.m_eDropZone != null) {
                iMicroElement.setAttribute(CHTMLAttributes.DROPZONE, (IHasAttributeValue)this.m_eDropZone);
            }
            if (this.m_bHidden) {
                iMicroElement.setAttribute(CHTMLAttributes.HIDDEN, CHTMLAttributeValues.HIDDEN);
            }
            if (this.m_bSpellCheck) {
                iMicroElement.setAttribute(CHTMLAttributes.SPELLCHECK, CHTMLAttributeValues.SPELLCHECK);
            }
        }
        if (this.m_eRole != null) {
            iMicroElement.setAttribute(CHTMLAttributes.ROLE, this.m_eRole.getID());
        }
        if (this.m_aCustomAttrs != null) {
            for (Map.Entry entry : this.m_aCustomAttrs.entrySet()) {
                iMicroElement.setAttribute((IMicroQName)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @OverrideOnDemand
    protected void finishMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    protected IMicroNode internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        IMicroElement iMicroElement = this.createMicroElement(iHCConversionSettingsToNode);
        if (iMicroElement == null) {
            throw new IllegalStateException("Created a null element!");
        }
        this.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        this.finishMicroElement(iMicroElement, iHCConversionSettingsToNode);
        return iMicroElement;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("element", this.m_eElement).append("elementName", this.m_sElementName).appendIfNotNull("ID", this.m_sID).appendIfNotNull("title", this.m_sTitle).appendIfNotNull("language", this.m_sLanguage).appendIfNotNull("direction", this.m_eDirection).appendIfNotNull("classes", this.m_aCSSClassProviders).appendIfNotNull("styles", this.m_aStyles).appendIfNotNull("JSHandler", this.m_aJSHandler).append("unfocusable", this.m_bUnfocusable).append("tabIndex", this.m_nTabIndex).appendIfNotNull("accessKey", this.m_sAccessKey).appendIfNotNull("translate", this.m_eTranslate).appendIfNotNull("contentEditable", this.m_eContentEditable).appendIfNotNull("contextMenu", this.m_sContextMenuID).appendIfNotNull("draggable", this.m_eDraggable).appendIfNotNull("dropZone", this.m_eDropZone).append("hidden", this.m_bHidden).append("spellcheck", this.m_bSpellCheck).appendIfNotNull("role", this.m_eRole).appendIfNotNull("customAttrs", this.m_aCustomAttrs).getToString();
    }

    private static final class HCAttrCont
    extends AttributeContainer<IMicroQName, String>
    implements IHCAttrContainer {
        private HCAttrCont() {
        }
    }
}

