/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.html.IHCHasHTMLAttributeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHCTextDirection implements IHCHasHTMLAttributeValue
{
    LTR("ltr"),
    RTL("rtl"),
    AUTO("auto");

    public static final EHCTextDirection DEFAULT;
    public static final EHCTextDirection DEFAULT_HTML5;
    private final String m_sAttrValue;

    private EHCTextDirection(String string2) {
        this.m_sAttrValue = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Nullable
    public static EHCTextDirection getFromAttrValueOrNull(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return EnumHelper.findFirst(EHCTextDirection.class, eHCTextDirection -> eHCTextDirection.getAttrValue().equals(string));
    }

    static {
        DEFAULT = LTR;
        DEFAULT_HTML5 = AUTO;
    }
}

