/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EContinue;
import com.helger.commons.wrapper.Wrapper;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HCHTMLHelper {
    private HCHTMLHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCElement<?>> recursiveGetAllChildrenWithTagName(@Nonnull IHCNode iHCNode3, EHTMLElement ... eHTMLElementArray) {
        ValueEnforcer.notNull(iHCNode3, "Owner");
        ValueEnforcer.notEmpty(eHTMLElementArray, "Elements");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        HCHelper.iterateChildrenNonBreakable(iHCNode3, (iHCNode, iHCNode2) -> {
            if (iHCNode2 instanceof IHCElement) {
                IHCElement iHCElement = (IHCElement)iHCNode2;
                String string = iHCElement.getTagName();
                for (EHTMLElement eHTMLElement : eHTMLElementArray) {
                    if (!string.equalsIgnoreCase(eHTMLElement.getElementName())) continue;
                    commonsArrayList.add(iHCElement);
                    break;
                }
            }
        });
        return commonsArrayList;
    }

    @Nullable
    public static IHCElement<?> recursiveGetFirstChildWithDifferentTagName(@Nonnull IHCNode iHCNode3, EHTMLElement ... eHTMLElementArray) {
        ValueEnforcer.notNull(iHCNode3, "Owner");
        ValueEnforcer.notEmpty(eHTMLElementArray, "Elements");
        Wrapper wrapper = new Wrapper();
        HCHelper.iterateChildrenNoCopy(iHCNode3, (iHCNode, iHCNode2) -> {
            if (iHCNode2 instanceof IHCElement) {
                IHCElement iHCElement = (IHCElement)iHCNode2;
                String string = iHCElement.getTagName();
                boolean bl = false;
                for (EHTMLElement eHTMLElement : eHTMLElementArray) {
                    if (!string.equalsIgnoreCase(eHTMLElement.getElementName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    wrapper.set(iHCElement);
                    return EContinue.BREAK;
                }
            }
            return EContinue.CONTINUE;
        });
        return (IHCElement)wrapper.get();
    }

    public static boolean recursiveContainsChildWithDifferentTagName(@Nonnull IHCNode iHCNode, EHTMLElement ... eHTMLElementArray) {
        return HCHTMLHelper.recursiveGetFirstChildWithDifferentTagName(iHCNode, eHTMLElementArray) != null;
    }

    @Nullable
    public static IHCElement<?> recursiveGetFirstChildWithTagName(@Nonnull IHCNode iHCNode3, EHTMLElement ... eHTMLElementArray) {
        ValueEnforcer.notNull(iHCNode3, "Owner");
        ValueEnforcer.notEmpty(eHTMLElementArray, "Elements");
        Wrapper wrapper = new Wrapper();
        HCHelper.iterateChildrenNoCopy(iHCNode3, (iHCNode, iHCNode2) -> {
            if (iHCNode2 instanceof IHCElement) {
                IHCElement iHCElement = (IHCElement)iHCNode2;
                String string = iHCElement.getTagName();
                for (EHTMLElement eHTMLElement : eHTMLElementArray) {
                    if (!string.equalsIgnoreCase(eHTMLElement.getElementName())) continue;
                    wrapper.set(iHCElement);
                    return EContinue.BREAK;
                }
            }
            return EContinue.CONTINUE;
        });
        return (IHCElement)wrapper.get();
    }

    public static boolean recursiveContainsChildWithTagName(@Nonnull IHCNode iHCNode, EHTMLElement ... eHTMLElementArray) {
        return HCHTMLHelper.recursiveGetFirstChildWithTagName(iHCNode, eHTMLElementArray) != null;
    }
}

