/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.hc.html.IHCHasHTMLAttributeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HC_Target
implements IHCHasHTMLAttributeValue {
    public static final HC_Target BLANK = new HC_Target("_blank");
    public static final HC_Target SELF = new HC_Target("_self");
    public static final HC_Target PARENT = new HC_Target("_parent");
    public static final HC_Target TOP = new HC_Target("_top");
    private final String m_sName;

    public HC_Target(@Nonnull @Nonempty String string) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getAttrValue() {
        return this.getName();
    }

    public String toString() {
        return new ToStringGenerator(super.toString()).append("name", this.m_sName).getToString();
    }

    @Nullable
    public static HC_Target getFromName(@Nonnull String string, @Nullable HC_Target hC_Target) {
        if (BLANK.getAttrValue().equalsIgnoreCase(string)) {
            return BLANK;
        }
        if (SELF.getAttrValue().equalsIgnoreCase(string)) {
            return SELF;
        }
        if (PARENT.getAttrValue().equalsIgnoreCase(string)) {
            return PARENT;
        }
        if (TOP.getAttrValue().equalsIgnoreCase(string)) {
            return TOP;
        }
        return hC_Target;
    }
}

