/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.embedded.EHCObjectAlign;
import com.helger.html.hc.html.embedded.IHCObject;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCObject<IMPLTYPE extends AbstractHCObject<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCObject<IMPLTYPE> {
    public static final boolean DEFAULT_DECLARE = false;
    private int m_nWidth = -1;
    private int m_nHeight = -1;
    private String m_sHSpace;
    private String m_sVSpace;
    private EHCObjectAlign m_eAlign;
    private String m_sArchive;
    private String m_sBorder;
    private String m_sClassID;
    private ISimpleURL m_aCodeBase;
    private IMimeType m_aCodeType;
    private ISimpleURL m_aData;
    private boolean m_bDeclare = false;
    private String m_sName;
    private String m_sStandBy;
    private IMimeType m_aType;
    private String m_sUseMap;

    public AbstractHCObject() {
        super(EHTMLElement.OBJECT);
    }

    @Override
    public final int getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setWidth(int n) {
        this.m_nWidth = n;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    public final int getHeight() {
        return this.m_nHeight;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHeight(int n) {
        this.m_nHeight = n;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getHSpace() {
        return this.m_sHSpace;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHSpace(@Nullable String string) {
        this.m_sHSpace = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getVSpace() {
        return this.m_sVSpace;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setVSpace(@Nullable String string) {
        this.m_sVSpace = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCObjectAlign getAlign() {
        return this.m_eAlign;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAlign(@Nullable EHCObjectAlign eHCObjectAlign) {
        this.m_eAlign = eHCObjectAlign;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getArchive() {
        return this.m_sArchive;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setArchive(@Nullable String string) {
        this.m_sArchive = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getBorder() {
        return this.m_sBorder;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setBorder(@Nullable String string) {
        this.m_sBorder = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getClassID() {
        return this.m_sClassID;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setClassID(@Nullable String string) {
        this.m_sClassID = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getCodeBase() {
        return this.m_aCodeBase;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCodeBase(@Nullable ISimpleURL iSimpleURL) {
        this.m_aCodeBase = iSimpleURL;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMimeType getCodeType() {
        return this.m_aCodeType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCodeType(@Nullable IMimeType iMimeType) {
        this.m_aCodeType = iMimeType;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getData() {
        return this.m_aData;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setData(@Nullable ISimpleURL iSimpleURL) {
        this.m_aData = iSimpleURL;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    public final boolean isDeclare() {
        return this.m_bDeclare;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDeclare(boolean bl) {
        this.m_bDeclare = bl;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setName(@Nullable String string) {
        this.m_sName = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getStandBy() {
        return this.m_sStandBy;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setStandBy(@Nullable String string) {
        this.m_sStandBy = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getUseMap() {
        return this.m_sUseMap;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setUseMap(@Nullable String string) {
        this.m_sUseMap = string;
        return (IMPLTYPE)((AbstractHCObject)this.thisAsT());
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        if (this.m_aData == null && this.m_aType == null) {
            HCConsistencyChecker.consistencyError("OBJECT contains neither type nor data");
        }
    }

    @Override
    protected void fillMicroElement(@Nonnull IMicroElement iMicroElement, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_nWidth > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.WIDTH, this.m_nWidth);
        }
        if (this.m_nHeight > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.HEIGHT, this.m_nHeight);
        }
        if (StringHelper.hasText(this.m_sHSpace)) {
            iMicroElement.setAttribute(CHTMLAttributes.HSPACE, this.m_sHSpace);
        }
        if (StringHelper.hasText(this.m_sVSpace)) {
            iMicroElement.setAttribute(CHTMLAttributes.VSPACE, this.m_sVSpace);
        }
        if (this.m_eAlign != null) {
            iMicroElement.setAttribute(CHTMLAttributes.ALIGN, (IHasAttributeValue)this.m_eAlign);
        }
        if (StringHelper.hasText(this.m_sArchive)) {
            iMicroElement.setAttribute(CHTMLAttributes.ARCHIVE, this.m_sArchive);
        }
        if (StringHelper.hasText(this.m_sBorder)) {
            iMicroElement.setAttribute(CHTMLAttributes.BORDER, this.m_sBorder);
        }
        if (StringHelper.hasText(this.m_sClassID)) {
            iMicroElement.setAttribute(CHTMLAttributes.CLASSID, this.m_sClassID);
        }
        if (this.m_aCodeBase != null) {
            iMicroElement.setAttribute(CHTMLAttributes.CODEBASE, this.m_aCodeBase.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset()));
        }
        if (this.m_aCodeType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.CODETYPE, this.m_aCodeType.getAsString());
        }
        if (this.m_aData != null) {
            iMicroElement.setAttribute(CHTMLAttributes.DATA, this.m_aData.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset()));
        }
        if (this.m_bDeclare) {
            iMicroElement.setAttribute(CHTMLAttributes.DECLARE, CHTMLAttributeValues.DECLARE);
        }
        if (StringHelper.hasText(this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (StringHelper.hasText(this.m_sStandBy)) {
            iMicroElement.setAttribute(CHTMLAttributes.STANDBY, this.m_sStandBy);
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
        if (StringHelper.hasText(this.m_sUseMap)) {
            iMicroElement.setAttribute(CHTMLAttributes.USEMAP, this.m_sUseMap);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("width", this.m_nWidth).append("height", this.m_nHeight).appendIfNotNull("hspace", this.m_sHSpace).appendIfNotNull("vspace", this.m_sVSpace).appendIfNotNull("align", this.m_eAlign).appendIfNotNull("archive", this.m_sArchive).appendIfNotNull("border", this.m_sBorder).appendIfNotNull("classID", this.m_sClassID).appendIfNotNull("codeBase", this.m_aCodeBase).appendIfNotNull("codeType", this.m_aCodeType).appendIfNotNull("data", this.m_aData).append("declare", this.m_bDeclare).appendIfNotNull("name", this.m_sName).appendIfNotNull("standBy", this.m_sStandBy).appendIfNotNull("type", this.m_aType).appendIfNotNull("useMap", this.m_sUseMap).getToString();
    }
}

