/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCEmbed
extends AbstractHCElement<HCEmbed> {
    public static final boolean DEFAULT_AUTO_START = false;
    public static final boolean DEFAULT_LOOP = false;
    private ISimpleURL m_aSrc;
    private int m_nWidth = -1;
    private int m_nHeight = -1;
    private String m_sPluginURL;
    private String m_sPluginsPage;
    private boolean m_bAutoStart = false;
    private boolean m_bLoop = false;
    private String m_sPalette;
    private IMimeType m_aType;

    public HCEmbed() {
        super(EHTMLElement.EMBED);
    }

    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Nonnull
    public final HCEmbed setSrc(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSrc = iSimpleURL;
        return this;
    }

    public final int getWidth() {
        return this.m_nWidth;
    }

    @Nonnull
    public final HCEmbed setWidth(int n) {
        this.m_nWidth = n;
        return this;
    }

    public final int getHeight() {
        return this.m_nHeight;
    }

    @Nonnull
    public final HCEmbed setHeight(int n) {
        this.m_nHeight = n;
        return this;
    }

    @Nullable
    public final String getPluginURL() {
        return this.m_sPluginURL;
    }

    @Nonnull
    public final HCEmbed setPluginURL(@Nullable String string) {
        this.m_sPluginURL = string;
        return this;
    }

    @Nullable
    public final String getPluginsPage() {
        return this.m_sPluginsPage;
    }

    @Nonnull
    public final HCEmbed setPluginsPage(@Nullable String string) {
        this.m_sPluginsPage = string;
        return this;
    }

    public final boolean isAutoStart() {
        return this.m_bAutoStart;
    }

    @Nonnull
    public final HCEmbed setAutoStart(boolean bl) {
        this.m_bAutoStart = bl;
        return this;
    }

    public final boolean isLoop() {
        return this.m_bLoop;
    }

    @Nonnull
    public final HCEmbed setLoop(boolean bl) {
        this.m_bLoop = bl;
        return this;
    }

    @Nullable
    public final String getPalette() {
        return this.m_sPalette;
    }

    @Nonnull
    public final HCEmbed setPalette(@Nullable String string) {
        this.m_sPalette = string;
        return this;
    }

    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Nonnull
    public final HCEmbed setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SRC, this.m_aSrc.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset()));
        }
        if (this.m_nWidth > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.WIDTH, this.m_nWidth);
        }
        if (this.m_nHeight > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.HEIGHT, this.m_nHeight);
        }
        if (StringHelper.hasText(this.m_sPluginURL)) {
            iMicroElement.setAttribute(CHTMLAttributes.PLUGINURL, this.m_sPluginURL);
        }
        if (StringHelper.hasText(this.m_sPluginsPage)) {
            iMicroElement.setAttribute(CHTMLAttributes.PLUGINSPAGE, this.m_sPluginsPage);
        }
        if (this.m_bAutoStart) {
            iMicroElement.setAttribute(CHTMLAttributes.AUTOSTART, Boolean.toString(this.m_bAutoStart));
        }
        if (this.m_bLoop) {
            iMicroElement.setAttribute(CHTMLAttributes.LOOP, Boolean.toString(this.m_bLoop));
        }
        if (StringHelper.hasText(this.m_sPalette)) {
            iMicroElement.setAttribute(CHTMLAttributes.PALETTE, this.m_sPalette);
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIfNotNull("src", this.m_aSrc).append("width", this.m_nWidth).append("height", this.m_nHeight).appendIfNotNull("pluginURL", this.m_sPluginURL).appendIfNotNull("pluginsPage", this.m_sPluginsPage).append("autoStart", this.m_bAutoStart).append("loop", this.m_bLoop).appendIfNotNull("palette", this.m_sPalette).appendIfNotNull("type", this.m_aType).getToString();
    }
}

