/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.embedded.EHCParamValueType;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCParam
extends AbstractHCElement<HCParam> {
    private String m_sName;
    private String m_sValue;
    private EHCParamValueType m_eValueType;
    private IMimeType m_aType;

    public HCParam() {
        super(EHTMLElement.PARAM);
    }

    public HCParam(@Nonnull String string) {
        this();
        this.setName(string);
    }

    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final HCParam setName(@Nonnull String string) {
        this.m_sName = ValueEnforcer.notNull(string, "Name");
        return this;
    }

    @Nullable
    public final String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public final HCParam setValue(@Nullable String string) {
        this.m_sValue = string;
        return this;
    }

    @Nullable
    public final EHCParamValueType getValueType() {
        return this.m_eValueType;
    }

    @Nonnull
    public final HCParam setValueType(@Nullable EHCParamValueType eHCParamValueType) {
        this.m_eValueType = eHCParamValueType;
        return this;
    }

    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Nonnull
    public final HCParam setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.hasText(this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (StringHelper.hasText(this.m_sValue)) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUE, this.m_sValue);
        }
        if (this.m_eValueType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUETYPE, (IHasAttributeValue)this.m_eValueType);
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
        iMicroElement.appendText("");
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIfNotNull("name", this.m_sName).appendIfNotNull("value", this.m_sValue).appendIfNotNull("valueType", this.m_eValueType).appendIfNotNull("type", this.m_aType).getToString();
    }
}

