/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.HCHTMLHelper;
import com.helger.html.hc.html.HC_Action;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.forms.EHCFormMethod;
import com.helger.html.hc.html.forms.HCButton_Submit;
import com.helger.html.hc.html.forms.IHCForm;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCForm<IMPLTYPE extends AbstractHCForm<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCForm<IMPLTYPE> {
    public static final ETriState DEFAULT_AUTO_COMPLETE = ETriState.UNDEFINED;
    public static final EHCFormMethod DEFAULT_METHOD = EHCFormMethod.POST;
    public static final boolean DEFAULT_NOVALIDATE = false;
    public static final boolean DEFAULT_SUBMIT_PRESSING_ENTER = false;
    public static final ICSSClassProvider CSS_CLASS_INVISIBLE_BUTTON = DefaultCSSClassProvider.create("invisible-button");
    private String m_sAcceptCharset;
    private final HC_Action m_aAction = new HC_Action();
    private ETriState m_eAutoComplete = DEFAULT_AUTO_COMPLETE;
    private IMimeType m_aEncType;
    private EHCFormMethod m_eMethod = DEFAULT_METHOD;
    private String m_sName;
    private boolean m_bNoValidate = false;
    private HC_Target m_aTarget;
    private boolean m_bSubmitPressingEnter = false;
    private int m_nSubmitButtonTabIndex = -1;

    public AbstractHCForm() {
        super(EHTMLElement.FORM);
    }

    public AbstractHCForm(@Nullable ISimpleURL iSimpleURL) {
        this();
        this.setAction(iSimpleURL);
    }

    public AbstractHCForm(@Nullable IHasJSCodeWithSettings iHasJSCodeWithSettings) {
        this();
        this.setAction(iHasJSCodeWithSettings);
    }

    @Override
    @Nullable
    public final String getAcceptCharset() {
        return this.m_sAcceptCharset;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAcceptCharset(@Nullable String string) {
        this.m_sAcceptCharset = string;
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getActionURL() {
        return this.m_aAction.getActionURL();
    }

    @Override
    @Nullable
    public final IHasJSCode getActionJS() {
        return this.m_aAction.getActionJS();
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAction(@Nullable ISimpleURL iSimpleURL) {
        this.m_aAction.setAction(iSimpleURL);
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAction(@Nullable IHasJSCodeWithSettings iHasJSCodeWithSettings) {
        this.m_aAction.setAction(iHasJSCodeWithSettings);
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    public final boolean isAutoCompleteOn() {
        return this.m_eAutoComplete.isTrue();
    }

    @Override
    public final boolean isAutoCompleteOff() {
        return this.m_eAutoComplete.isFalse();
    }

    @Override
    public final boolean isAutoCompleteUndefined() {
        return this.m_eAutoComplete.isUndefined();
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAutoComplete(@Nonnull ETriState eTriState) {
        this.m_eAutoComplete = ValueEnforcer.notNull(eTriState, "AutoComplete");
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMimeType getEncType() {
        return this.m_aEncType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setEncType(@Nullable IMimeType iMimeType) {
        this.m_aEncType = iMimeType;
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCFormMethod getMethod() {
        return this.m_eMethod;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMethod(@Nullable EHCFormMethod eHCFormMethod) {
        this.m_eMethod = eHCFormMethod;
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setName(@Nullable String string) {
        this.m_sName = string;
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    public final boolean isNoValidate() {
        return this.m_bNoValidate;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setNoValidate(boolean bl) {
        this.m_bNoValidate = bl;
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    @Nullable
    public final HC_Target getTarget() {
        return this.m_aTarget;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTarget(@Nullable HC_Target hC_Target) {
        this.m_aTarget = hC_Target;
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    public final boolean isSubmitPressingEnter() {
        return this.m_bSubmitPressingEnter;
    }

    @Override
    public final int getSubmitButtonTabIndex() {
        return this.m_nSubmitButtonTabIndex;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSubmitPressingEnter(boolean bl, int n) {
        this.m_bSubmitPressingEnter = bl;
        this.m_nSubmitButtonTabIndex = n;
        return (IMPLTYPE)((AbstractHCForm)this.thisAsT());
    }

    @Override
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        if (this.m_bSubmitPressingEnter) {
            this.addChild(((HCButton_Submit)new HCButton_Submit("").addClass(CSS_CLASS_INVISIBLE_BUTTON)).setTabIndex(this.m_nSubmitButtonTabIndex));
        }
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        if (HCHTMLHelper.recursiveContainsChildWithTagName(this, EHTMLElement.FORM)) {
            HCConsistencyChecker.consistencyError("FORM contains other nested form");
        }
    }

    @Override
    protected void fillMicroElement(@Nonnull IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.hasText(this.m_sAcceptCharset)) {
            iMicroElement.setAttribute(CHTMLAttributes.ACCEPTCHARSET, this.m_sAcceptCharset);
        }
        this.m_aAction.applyProperties(CHTMLAttributes.ACTION, iMicroElement, iHCConversionSettingsToNode.getJSWriterSettings(), iHCConversionSettingsToNode.getCharset());
        if (this.m_eAutoComplete.isDefined()) {
            iMicroElement.setAttribute(CHTMLAttributes.AUTOCOMPLETE, this.m_eAutoComplete.isTrue() ? "on" : "off");
        }
        if (this.m_aEncType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.ENCTYPE, this.m_aEncType.getAsString());
        }
        if (this.m_eMethod != null) {
            iMicroElement.setAttribute(CHTMLAttributes.METHOD, (IHasAttributeValue)this.m_eMethod);
        }
        if (StringHelper.hasText(this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (this.m_aTarget != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TARGET, (IHasAttributeValue)this.m_aTarget);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIfNotNull("acceptCharset", this.m_sAcceptCharset).append("action", this.m_aAction).append("autoComplete", this.m_eAutoComplete).appendIfNotNull("encType", this.m_aEncType).appendIfNotNull("method", this.m_eMethod).appendIfNotNull("name", this.m_sName).appendIfNotNull("target", this.m_aTarget).append("submitPressingEnter", this.m_bSubmitPressingEnter).append("submitButtonTabIndex", this.m_nSubmitButtonTabIndex).getToString();
    }
}

