/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.equals.EqualsHelper;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.annotation.SinceHTML5;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.HCHTMLHelper;
import com.helger.html.hc.html.forms.IHCMeter;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;

@SinceHTML5
public abstract class AbstractHCMeter<IMPLTYPE extends AbstractHCMeter<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCMeter<IMPLTYPE> {
    private double m_dValue = Double.NaN;
    private double m_dMin = Double.NaN;
    private double m_dMax = Double.NaN;
    private double m_dLow = Double.NaN;
    private double m_dHigh = Double.NaN;
    private double m_dOptimum = Double.NaN;

    public AbstractHCMeter() {
        super(EHTMLElement.METER);
    }

    @Override
    public final double getValue() {
        return this.m_dValue;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setValue(double d) {
        this.m_dValue = d;
        return (IMPLTYPE)((AbstractHCMeter)this.thisAsT());
    }

    @Override
    public final double getMin() {
        return this.m_dMin;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMin(double d) {
        this.m_dMin = d;
        return (IMPLTYPE)((AbstractHCMeter)this.thisAsT());
    }

    @Override
    public final double getMax() {
        return this.m_dMax;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMax(double d) {
        this.m_dMax = d;
        return (IMPLTYPE)((AbstractHCMeter)this.thisAsT());
    }

    @Override
    public final double getLow() {
        return this.m_dLow;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setLow(double d) {
        this.m_dLow = d;
        return (IMPLTYPE)((AbstractHCMeter)this.thisAsT());
    }

    @Override
    public final double getHigh() {
        return this.m_dHigh;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHigh(double d) {
        this.m_dHigh = d;
        return (IMPLTYPE)((AbstractHCMeter)this.thisAsT());
    }

    @Override
    public final double getOptimum() {
        return this.m_dOptimum;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setOptimum(double d) {
        this.m_dOptimum = d;
        return (IMPLTYPE)((AbstractHCMeter)this.thisAsT());
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        if (HCHTMLHelper.recursiveContainsChildWithTagName(this, EHTMLElement.METER)) {
            HCConsistencyChecker.consistencyError("METER contains other nested meter");
        }
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (!EqualsHelper.equals(this.m_dValue, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUE, Double.toString(this.m_dValue));
        }
        if (!EqualsHelper.equals(this.m_dMin, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.MIN, Double.toString(this.m_dMin));
        }
        if (!EqualsHelper.equals(this.m_dMax, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.MAX, Double.toString(this.m_dMax));
        }
        if (!EqualsHelper.equals(this.m_dLow, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.LOW, Double.toString(this.m_dLow));
        }
        if (!EqualsHelper.equals(this.m_dHigh, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.HIGH, Double.toString(this.m_dHigh));
        }
        if (!EqualsHelper.equals(this.m_dOptimum, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.OPTIMUM, Double.toString(this.m_dOptimum));
        }
    }
}

