/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.equals.EqualsHelper;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.annotation.SinceHTML5;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.HCHTMLHelper;
import com.helger.html.hc.html.forms.IHCProgress;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;

@SinceHTML5
public abstract class AbstractHCProgress<IMPLTYPE extends AbstractHCProgress<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCProgress<IMPLTYPE> {
    private double m_dValue = Double.NaN;
    private double m_dMax = Double.NaN;

    public AbstractHCProgress() {
        super(EHTMLElement.PROGRESS);
    }

    @Override
    public final double getValue() {
        return this.m_dValue;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setValue(double d) {
        this.m_dValue = d;
        return (IMPLTYPE)((AbstractHCProgress)this.thisAsT());
    }

    @Override
    public final double getMax() {
        return this.m_dMax;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMax(double d) {
        this.m_dMax = d;
        return (IMPLTYPE)((AbstractHCProgress)this.thisAsT());
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        if (HCHTMLHelper.recursiveContainsChildWithTagName(this, EHTMLElement.PROGRESS)) {
            HCConsistencyChecker.consistencyError("PROGRESS contains other nested progress");
        }
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (!EqualsHelper.equals(this.m_dValue, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUE, Double.toString(this.m_dValue));
        }
        if (!EqualsHelper.equals(this.m_dMax, Double.NaN)) {
            iMicroElement.setAttribute(CHTMLAttributes.MAX, Double.toString(this.m_dMax));
        }
    }
}

