/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.forms.AbstractHCControl;
import com.helger.html.hc.html.forms.EHCTextAreaWrap;
import com.helger.html.hc.html.forms.IHCTextArea;
import com.helger.html.request.IHCRequestField;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractHCTextArea<IMPLTYPE extends AbstractHCTextArea<IMPLTYPE>>
extends AbstractHCControl<IMPLTYPE>
implements IHCTextArea<IMPLTYPE> {
    public static final ETriState DEFAULT_AUTO_COMPLETE = ETriState.UNDEFINED;
    private ETriState m_eAutoComplete = DEFAULT_AUTO_COMPLETE;
    private int m_nCols = -1;
    private String m_sDirName;
    private String m_sForm;
    private int m_nMaxLength = -1;
    private int m_nMinLength = -1;
    private String m_sPlaceholder;
    private int m_nRows = HCSettings.getTextAreaDefaultRows();
    private String m_sValue;
    private EHCTextAreaWrap m_eWrap;

    public AbstractHCTextArea() {
        super(EHTMLElement.TEXTAREA);
    }

    public AbstractHCTextArea(@Nullable String string) {
        this();
        this.setName(string);
    }

    public AbstractHCTextArea(@Nullable String string, @Nullable String string2) {
        this(string);
        this.setValue(string2);
    }

    public AbstractHCTextArea(@Nonnull IHCRequestField iHCRequestField) {
        this(iHCRequestField.getFieldName(), iHCRequestField.getRequestValue());
    }

    @Override
    public final boolean isAutoCompleteOn() {
        return this.m_eAutoComplete.isTrue();
    }

    @Override
    public final boolean isAutoCompleteOff() {
        return this.m_eAutoComplete.isFalse();
    }

    @Override
    public final boolean isAutoCompleteUndefined() {
        return this.m_eAutoComplete.isUndefined();
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAutoComplete(@Nonnull ETriState eTriState) {
        this.m_eAutoComplete = ValueEnforcer.notNull(eTriState, "AutoComplete");
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    public final int getCols() {
        return this.m_nCols;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCols(int n) {
        this.m_nCols = n;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getDirName() {
        return this.m_sDirName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDirName(@Nullable String string) {
        this.m_sDirName = string;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getForm() {
        return this.m_sForm;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setForm(@Nullable String string) {
        this.m_sForm = string;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    public final int getMaxLength() {
        return this.m_nMaxLength;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMaxLength(int n) {
        this.m_nMaxLength = n;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    public final int getMinLength() {
        return this.m_nMinLength;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMinLength(int n) {
        this.m_nMinLength = n;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getPlaceholder() {
        return this.m_sPlaceholder;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPlaceholder(@Nullable String string) {
        this.m_sPlaceholder = string;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    public final int getRows() {
        return this.m_nRows;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setRows(int n) {
        this.m_nRows = n;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getValue() {
        return this.m_sValue;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setValue(@Nullable String string) {
        this.m_sValue = string;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCTextAreaWrap getWrap() {
        return this.m_eWrap;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setWrap(@Nullable EHCTextAreaWrap eHCTextAreaWrap) {
        this.m_eWrap = eHCTextAreaWrap;
        return (IMPLTYPE)((AbstractHCTextArea)this.thisAsT());
    }

    @Override
    @Nonnull
    public String getPlainText() {
        return StringHelper.getNotNull(this.m_sValue);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_eAutoComplete.isDefined()) {
            iMicroElement.setAttribute(CHTMLAttributes.AUTOCOMPLETE, this.m_eAutoComplete.isTrue() ? "on" : "off");
        }
        if (this.m_nCols > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.COLS, this.m_nCols);
        }
        if (StringHelper.hasText(this.m_sDirName)) {
            iMicroElement.setAttribute(CHTMLAttributes.DIRNAME, this.m_sDirName);
        }
        if (StringHelper.hasText(this.m_sForm)) {
            iMicroElement.setAttribute(CHTMLAttributes.FORM, this.m_sForm);
        }
        if (this.m_nMaxLength > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.MAXLENGTH, this.m_nMaxLength);
        }
        if (this.m_nMinLength > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.MINLENGTH, this.m_nMinLength);
        }
        if (StringHelper.hasText(this.m_sPlaceholder)) {
            iMicroElement.setAttribute(CHTMLAttributes.PLACEHOLDER, this.m_sPlaceholder);
        }
        if (this.m_nRows > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.ROWS, this.m_nRows);
        }
        if (this.m_eWrap != null) {
            iMicroElement.setAttribute(CHTMLAttributes.WRAP, (IHasAttributeValue)this.m_eWrap);
        }
        iMicroElement.appendText(this.getPlainText());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("autoComplete", this.m_eAutoComplete).append("cols", this.m_nCols).appendIfNotNull("dirname", this.m_sDirName).appendIfNotNull("form", this.m_sForm).append("maxLength", this.m_nMaxLength).append("minLength", this.m_nMinLength).appendIfNotNull("placeholder", this.m_sPlaceholder).append("rows", this.m_nRows).appendIfNotNull("value", this.m_sValue).appendIfNotNull("wrap", this.m_eWrap).getToString();
    }
}

