/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.IHCControl;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HCCtrlHelper {
    private HCCtrlHelper() {
    }

    @Nullable
    public static IHCControl<?> getFirstHCControl(@Nullable IHCNode iHCNode) {
        if (iHCNode != null) {
            if (iHCNode instanceof IHCControl) {
                return (IHCControl)iHCNode;
            }
            if (iHCNode.hasChildren()) {
                for (IHCNode iHCNode2 : iHCNode.getAllChildren()) {
                    IHCControl<?> iHCControl = HCCtrlHelper.getFirstHCControl(iHCNode2);
                    if (iHCControl == null) continue;
                    return iHCControl;
                }
            }
        }
        return null;
    }

    public static void getAllHCControls(@Nullable IHCNode iHCNode2, @Nonnull Consumer<? super IHCControl<?>> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        if (iHCNode2 != null) {
            if (iHCNode2 instanceof IHCControl) {
                consumer.accept((IHCControl)iHCNode2);
            }
            iHCNode2.forAllChildren(iHCNode -> HCCtrlHelper.getAllHCControls(iHCNode, consumer));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCControl<?>> getAllHCControls(@Nullable IHCNode iHCNode) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        HCCtrlHelper.getAllHCControls(iHCNode, commonsArrayList::add);
        return commonsArrayList;
    }

    public static void getAllHCControls(@Nullable Iterable<? extends IHCNode> iterable, @Nonnull Consumer<? super IHCControl<?>> consumer) {
        ValueEnforcer.notNull(consumer, "TargetList");
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                HCCtrlHelper.getAllHCControls(iHCNode, consumer);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCControl<?>> getAllHCControls(@Nullable Iterable<? extends IHCNode> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        HCCtrlHelper.getAllHCControls(iterable, commonsArrayList::add);
        return commonsArrayList;
    }
}

