/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.forms.HCLegend;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public class HCFieldSet
extends AbstractHCElementWithChildren<HCFieldSet> {
    public static final boolean DEFAULT_DISABLED = false;
    private boolean m_bDisabled = false;
    private String m_sForm;
    private String m_sName;

    public HCFieldSet() {
        super(EHTMLElement.FIELDSET);
    }

    public HCFieldSet(@Nullable String string) {
        this();
        if (string != null) {
            this.addChild((IHCNode)new HCLegend().addChild(string));
        }
    }

    public final boolean isDisabled() {
        return this.m_bDisabled;
    }

    @Nonnull
    public final HCFieldSet setDisabled(boolean bl) {
        this.m_bDisabled = bl;
        return (HCFieldSet)this.thisAsT();
    }

    @Nullable
    public final String getForm() {
        return this.m_sForm;
    }

    @Nonnull
    public final HCFieldSet setForm(@Nullable String string) {
        this.m_sForm = string;
        return (HCFieldSet)this.thisAsT();
    }

    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final HCFieldSet setName(@Nullable String string) {
        this.m_sName = string;
        return (HCFieldSet)this.thisAsT();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_bDisabled) {
            iMicroElement.setAttribute(CHTMLAttributes.DISABLED, CHTMLAttributeValues.DISABLED);
        }
        if (StringHelper.hasText(this.m_sForm)) {
            iMicroElement.setAttribute(CHTMLAttributes.FORM, this.m_sForm);
        }
        if (StringHelper.hasText(this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("disabled", this.m_bDisabled).appendIfNotNull("form", this.m_sForm).appendIfNotNull("name", this.m_sName).getToString();
    }
}

