/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.interactive;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.html.IHCHasHTMLAttributeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHCCommandType implements IHCHasHTMLAttributeValue
{
    CHECKBOX("checkbox"),
    COMMAND("command"),
    RADIO("radio");

    @Nonnull
    public static final EHCCommandType DEFAULT;
    private final String m_sAttrValue;

    private EHCCommandType(String string2) {
        this.m_sAttrValue = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Nullable
    public static EHCCommandType getFromAttrValueOrNull(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return EnumHelper.findFirst(EHCCommandType.class, eHCCommandType -> eHCCommandType.hasAttrValue(string));
    }

    static {
        DEFAULT = COMMAND;
    }
}

