/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.metadata;

import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.metadata.HCLink;
import com.helger.html.hc.html.metadata.HCStyle;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class HCCSSNodeDetector {
    private static final HCCSSNodeDetector s_aInstance = new HCCSSNodeDetector();

    private HCCSSNodeDetector() {
    }

    public static boolean isCSSNode(@Nullable IHCNode iHCNode) {
        IHCNode iHCNode2 = HCHelper.getUnwrappedNode(iHCNode);
        return HCCSSNodeDetector.isDirectCSSNode(iHCNode2);
    }

    public static boolean isDirectCSSNode(@Nullable IHCNode iHCNode) {
        return HCCSSNodeDetector.isDirectCSSInlineNode(iHCNode) || HCCSSNodeDetector.isDirectCSSFileNode(iHCNode);
    }

    public static boolean isCSSInlineNode(@Nullable IHCNode iHCNode) {
        IHCNode iHCNode2 = HCHelper.getUnwrappedNode(iHCNode);
        return HCCSSNodeDetector.isDirectCSSInlineNode(iHCNode2);
    }

    public static boolean isDirectCSSInlineNode(@Nullable IHCNode iHCNode) {
        return iHCNode instanceof HCStyle;
    }

    public static boolean isCSSFileNode(@Nullable IHCNode iHCNode) {
        IHCNode iHCNode2 = HCHelper.getUnwrappedNode(iHCNode);
        return HCCSSNodeDetector.isDirectCSSFileNode(iHCNode2);
    }

    public static boolean isDirectCSSFileNode(@Nullable IHCNode iHCNode) {
        return iHCNode instanceof HCLink && ((HCLink)iHCNode).isCSSLink();
    }
}

