/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.metadata;

import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCMeta
extends AbstractHCElement<HCMeta> {
    private String m_sName;
    private String m_sHttpEquiv;
    private String m_sContent;
    private String m_sCharset;

    public HCMeta() {
        super(EHTMLElement.META);
    }

    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final HCMeta setName(@Nullable String string) {
        this.m_sName = string;
        return this;
    }

    @Nullable
    public final String getHttpEquiv() {
        return this.m_sHttpEquiv;
    }

    @Nonnull
    public final HCMeta setHttpEquiv(@Nullable String string) {
        this.m_sHttpEquiv = string;
        return this;
    }

    @Nullable
    public final String getContent() {
        return this.m_sContent;
    }

    @Nonnull
    public final HCMeta setContent(@Nullable String string) {
        this.m_sContent = string;
        return this;
    }

    @Nullable
    public final String getCharset() {
        return this.m_sCharset;
    }

    @Nonnull
    public final HCMeta setCharset(@Nullable String string) {
        this.m_sCharset = string;
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.hasText(this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (StringHelper.hasText(this.m_sHttpEquiv)) {
            iMicroElement.setAttribute(CHTMLAttributes.HTTP_EQUIV, this.m_sHttpEquiv);
        }
        if (StringHelper.hasText(this.m_sContent)) {
            iMicroElement.setAttribute(CHTMLAttributes.CONTENT, this.m_sContent);
        }
        if (StringHelper.hasText(this.m_sCharset)) {
            iMicroElement.setAttribute(CHTMLAttributes.CHARSET, this.m_sCharset);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("name", this.m_sName).append("httpEquiv", this.m_sHttpEquiv).append("content", this.m_sContent).append("charset", this.m_sCharset).getToString();
    }
}

