/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.metadata;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import com.helger.css.writer.CSSWriter;
import com.helger.css.writer.CSSWriterSettings;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.EHCStyleInlineMode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNodeWithChildren;
import com.helger.xml.microdom.MicroText;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@OutOfBandNode
public class HCStyle
extends AbstractHCElement<HCStyle> {
    public static final IMimeType DEFAULT_TYPE = CMimeType.TEXT_CSS;
    public static final boolean DEFAULT_EMIT_AFTER_FILES = true;
    private IMimeType m_aType = DEFAULT_TYPE;
    private CSSMediaList m_aMediaList;
    private String m_sContent;
    private EHCStyleInlineMode m_eMode = HCSettings.getStyleInlineMode();
    private boolean m_bEmitAfterFiles = true;

    public HCStyle() {
        super(EHTMLElement.STYLE);
    }

    public HCStyle(@Nullable String string) {
        this();
        this.setStyleContent(string);
    }

    public HCStyle(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull CSSWriterSettings cSSWriterSettings) {
        this();
        this.setStyleContent(cascadingStyleSheet, cSSWriterSettings);
    }

    public HCStyle(@Nonnull CSSDeclarationList cSSDeclarationList, @Nonnull CSSWriterSettings cSSWriterSettings) {
        this();
        this.setStyleContent(cSSDeclarationList, cSSWriterSettings);
    }

    @Nonnull
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Nonnull
    public final HCStyle setType(@Nonnull IMimeType iMimeType) {
        this.m_aType = ValueEnforcer.notNull(iMimeType, "Type");
        return this;
    }

    @Nullable
    public final ICSSMediaList getMedia() {
        return this.m_aMediaList;
    }

    @Nonnull
    public final HCStyle setMedia(@Nullable ICSSMediaList iCSSMediaList) {
        this.m_aMediaList = iCSSMediaList == null ? null : new CSSMediaList(iCSSMediaList);
        return this;
    }

    @Nonnull
    private CSSMediaList _ensureMediaListPresent() {
        if (this.m_aMediaList == null) {
            this.m_aMediaList = new CSSMediaList();
        }
        return this.m_aMediaList;
    }

    @Nonnull
    public final HCStyle addMedium(@Nonnull ECSSMedium eCSSMedium) {
        this._ensureMediaListPresent().addMedium(eCSSMedium);
        return this;
    }

    @Nonnull
    public final HCStyle removeAllMedia() {
        this.m_aMediaList = null;
        return this;
    }

    public final boolean containsMedium(@Nullable ECSSMedium eCSSMedium) {
        return this.m_aMediaList != null && this.m_aMediaList.containsMedium(eCSSMedium);
    }

    @Nonnegative
    public final int getMediaCount() {
        return this.m_aMediaList == null ? 0 : this.m_aMediaList.getMediaCount();
    }

    public final boolean hasAnyMedia() {
        return this.m_aMediaList != null && this.m_aMediaList.hasAnyMedia();
    }

    public final boolean hasNoMedia() {
        return this.m_aMediaList == null || !this.m_aMediaList.hasAnyMedia();
    }

    public final boolean hasNoMediaOrAll() {
        return this.hasNoMedia() || this.containsMedium(ECSSMedium.ALL);
    }

    @Nonnull
    public final HCStyle setStyleContent(@Nullable String string) {
        this.m_sContent = string;
        return this;
    }

    @Nonnull
    public final HCStyle setStyleContent(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull CSSWriterSettings cSSWriterSettings) {
        return this.setStyleContent(new CSSWriter(cSSWriterSettings).getCSSAsString(cascadingStyleSheet));
    }

    @Nonnull
    public final HCStyle setStyleContent(@Nonnull CSSDeclarationList cSSDeclarationList, @Nonnull CSSWriterSettings cSSWriterSettings) {
        return this.setStyleContent(new CSSWriter(cSSWriterSettings).getCSSAsString(cSSDeclarationList));
    }

    @Nullable
    public final String getStyleContent() {
        return this.m_sContent;
    }

    @Nonnull
    public final EHCStyleInlineMode getMode() {
        return this.m_eMode;
    }

    @Nonnull
    public final HCStyle setMode(@Nonnull EHCStyleInlineMode eHCStyleInlineMode) {
        this.m_eMode = ValueEnforcer.notNull(eHCStyleInlineMode, "Mode");
        return this;
    }

    public final boolean isEmitAfterFiles() {
        return this.m_bEmitAfterFiles;
    }

    @Nonnull
    public final HCStyle setEmitAfterFiles(boolean bl) {
        this.m_bEmitAfterFiles = bl;
        return this;
    }

    @Override
    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return StringHelper.hasText(this.m_sContent);
    }

    public static void setInlineStyle(@Nonnull IMicroNodeWithChildren iMicroNodeWithChildren, @Nullable String string, @Nonnull EHCStyleInlineMode eHCStyleInlineMode) {
        if (StringHelper.hasText(string)) {
            switch (eHCStyleInlineMode) {
                case PLAIN_TEXT: {
                    iMicroNodeWithChildren.appendText(string);
                    break;
                }
                case PLAIN_TEXT_NO_ESCAPE: {
                    if (StringHelper.containsIgnoreCase(string, "</script>", Locale.US)) {
                        throw new IllegalArgumentException("The script text contains a closing script tag!");
                    }
                    iMicroNodeWithChildren.appendChild(new MicroText(string).setEscape(false));
                }
            }
        }
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        if (this.hasAnyMedia()) {
            iMicroElement.setAttribute(CHTMLAttributes.MEDIA, this.m_aMediaList.getMediaString());
        }
        HCStyle.setInlineStyle(iMicroElement, this.m_sContent, this.m_eMode);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("type", this.m_aType).appendIfNotNull("mediaList", this.m_aMediaList).append("content", this.m_sContent).append("mode", this.m_eMode).append("emitAfterFiles", this.m_bEmitAfterFiles).getToString();
    }
}

