/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.root;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.EHTMLElement;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.EHCTextDirection;
import com.helger.html.hc.html.metadata.HCCSSNodeDetector;
import com.helger.html.hc.html.metadata.HCHead;
import com.helger.html.hc.html.script.HCJSNodeDetector;
import com.helger.html.hc.html.script.IHCScript;
import com.helger.html.hc.html.script.IHCScriptInline;
import com.helger.html.hc.html.sections.HCBody;
import com.helger.html.hc.special.HCSpecialNodeHandler;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCHtml
extends AbstractHCElement<HCHtml> {
    private final HCHead m_aHead;
    private final HCBody m_aBody;

    public HCHtml() {
        this(new HCHead(), new HCBody());
    }

    public HCHtml(@Nonnull HCHead hCHead, @Nonnull HCBody hCBody) {
        super(EHTMLElement.HTML);
        this.m_aHead = ValueEnforcer.notNull(hCHead, "Head");
        this.m_aBody = ValueEnforcer.notNull(hCBody, "Body");
        this.setDirection(EHCTextDirection.LTR);
    }

    @Nonnull
    public final HCHead head() {
        return this.m_aHead;
    }

    @Nonnull
    public final HCBody body() {
        return this.m_aBody;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<? extends IHCNode> getAllChildren() {
        return new CommonsArrayList<AbstractHCElement>(this.m_aHead, this.m_aBody);
    }

    @Override
    @Nonnull
    public final ICommonsIterable<? extends IHCNode> getChildren() {
        return this.getAllChildren();
    }

    @Override
    @Nullable
    public final IHCNode getChildAtIndex(int n) {
        if (n == 0) {
            return this.m_aHead;
        }
        if (n == 1) {
            return this.m_aBody;
        }
        return null;
    }

    @Override
    @Nonnull
    public final IHCNode getFirstChild() {
        return this.m_aHead;
    }

    @Override
    @Nonnull
    public final IHCNode getLastChild() {
        return this.m_aBody;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    @Nonnull
    protected final IMicroDocument internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        EHTMLVersion eHTMLVersion = iHCConversionSettingsToNode.getHTMLVersion();
        MicroDocument microDocument = new MicroDocument(eHTMLVersion.getDocType().getClone());
        IMicroElement iMicroElement = microDocument.appendElement(eHTMLVersion.getNamespaceURI(), eHTMLVersion.getDocType().getQualifiedName());
        this.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        IMicroNode iMicroNode = this.m_aBody.convertToMicroNode(iHCConversionSettingsToNode);
        iMicroElement.appendChild(iMicroNode);
        IMicroNode iMicroNode2 = this.m_aHead.convertToMicroNode(iHCConversionSettingsToNode);
        iMicroElement.insertAtIndex(0, iMicroNode2);
        return microDocument;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IHCNode> getAllOutOfBandNodesWithMergedInlineNodes() {
        CommonsArrayList<IHCNode> commonsArrayList = new CommonsArrayList<IHCNode>();
        this.m_aHead.getAllAndRemoveAllJSNodes(commonsArrayList);
        this.m_aHead.getAllAndRemoveAllCSSNodes(commonsArrayList);
        HCSpecialNodeHandler.recursiveExtractAndRemoveOutOfBandNodes(this.m_aBody, commonsArrayList);
        return HCSpecialNodeHandler.getMergedInlineCSSAndJSNodes(commonsArrayList, true);
    }

    public void addAllOutOfBandNodesToHead(@Nonnull List<IHCNode> list) {
        ValueEnforcer.notNull(list, "AllOOBNodes");
        for (IHCNode iHCNode : list) {
            IHCNode iHCNode2 = HCHelper.getUnwrappedNode(iHCNode);
            if (HCJSNodeDetector.isDirectJSNode(iHCNode2)) {
                this.m_aHead.addJS(iHCNode);
                continue;
            }
            if (HCCSSNodeDetector.isDirectCSSNode(iHCNode2)) {
                this.m_aHead.addCSS(iHCNode);
                continue;
            }
            throw new IllegalStateException("Found illegal out-of-band head node: " + iHCNode);
        }
    }

    public void moveScriptElementsToBody() {
        CommonsArrayList<IHCNode> commonsArrayList = new CommonsArrayList<IHCNode>();
        this.m_aHead.getAllAndRemoveAllJSNodes(commonsArrayList);
        int n = 0;
        if (this.m_aBody.hasChildren()) {
            for (IHCNode iHCNode : this.m_aBody.getAllChildren()) {
                if (iHCNode instanceof IHCScript) {
                    boolean bl;
                    boolean bl2 = bl = iHCNode instanceof IHCScriptInline && !((IHCScriptInline)iHCNode).isEmitAfterFiles();
                    if (!bl) break;
                }
                ++n;
            }
        }
        this.m_aBody.addChildrenAt(n, commonsArrayList);
    }

    @Override
    @Nonnull
    public String getPlainText() {
        return StringHelper.getConcatenatedOnDemand(this.m_aHead.getPlainText(), " ", this.m_aBody.getPlainText());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("head", this.m_aHead).append("body", this.m_aBody).getToString();
    }
}

