/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.tabular;

import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.tabular.EHCCellAlign;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractHCCell<IMPLTYPE extends AbstractHCCell<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCCell<IMPLTYPE> {
    private HCRow m_aParentRow;
    private int m_nColspan = -1;
    private int m_nRowspan = -1;
    private EHCCellAlign m_eAlign;

    public AbstractHCCell(@Nonnull EHTMLElement eHTMLElement) {
        super(eHTMLElement);
    }

    @Override
    @Nullable
    public final HCRow getParentRow() {
        return this.m_aParentRow;
    }

    @Nonnull
    public final IMPLTYPE internalSetParentRow(@Nullable HCRow hCRow) {
        this.m_aParentRow = hCRow;
        return (IMPLTYPE)((AbstractHCCell)this.thisAsT());
    }

    @Override
    @Nonnegative
    public final int getColspan() {
        return this.m_nColspan > 1 ? this.m_nColspan : 1;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setColspan(int n) {
        this.m_nColspan = n;
        return (IMPLTYPE)((AbstractHCCell)this.thisAsT());
    }

    @Override
    @Nonnegative
    public final int getRowspan() {
        return this.m_nRowspan > 1 ? this.m_nRowspan : 1;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setRowspan(int n) {
        this.m_nRowspan = n;
        return (IMPLTYPE)((AbstractHCCell)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCCellAlign getAlign() {
        return this.m_eAlign;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAlign(@Nullable EHCCellAlign eHCCellAlign) {
        this.m_eAlign = eHCCellAlign;
        return (IMPLTYPE)((AbstractHCCell)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_nColspan > 1) {
            iMicroElement.setAttribute(CHTMLAttributes.COLSPAN, this.m_nColspan);
        }
        if (this.m_nRowspan > 1) {
            iMicroElement.setAttribute(CHTMLAttributes.ROWSPAN, this.m_nRowspan);
        }
        if (this.m_eAlign != null) {
            iMicroElement.setAttribute(CHTMLAttributes.ALIGN, (IHasAttributeValue)this.m_eAlign);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("colspan", this.m_nColspan).append("rowSpan", this.m_nRowspan).append("align", this.m_eAlign).getToString();
    }
}

